/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Stack;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Version;

/**
 *
 * @author Martin Adamek
 */
public abstract class ProxyBean extends BaseBean implements PropertyChangeListener {

    private MergedProvider mergedProvider = MergedProvider.getDefault();
    private boolean listenerAdded = false;
    
    public ProxyBean(Vector comps, Version version) {
        super(comps, version);
    }
    
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!listenerAdded) {
            BaseBean dd = (BaseBean) mergedProvider.getXmlRoot(this);
            if (dd != null) {
                listenerAdded = true;
                dd.addPropertyChangeListener(this);
            }
        }
        super.addPropertyChangeListener(l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        BaseBean xmlRoot = (BaseBean) mergedProvider.getXmlRoot(this);
        Object newValue = evt.getNewValue();
        // removal of element from XML
        //  we need to find its entry in merged graph
        if (newValue == null) {
            Object oldValue = evt.getOldValue();
            if (oldValue instanceof BaseBean) {
                BaseBean foundBean = findBean(this, (BaseBean) oldValue);
                if (foundBean != null) {
                    foundBean._getParent().removeValue(foundBean.name(), foundBean);
                }
            }
        } else {
            merge(xmlRoot, BaseBean.MERGE_UNION);
        }
    }

    @Override
    public Object getValue(String name) {
        return getProxyValue(name, super.getValue(name));
    }

    @Override
    public String getAttributeValue(String name) {
        return (String) getProxyValue(name, super.getAttributeValue(name));
    }

    private Object getProxyValue(String propertyName, Object value) {
        // TODO: defaulting should be moved
        //  this is just temporary solution (ORM DD API is not in j2ee/ddapi)
        if ("EjbName".equals(propertyName) ||
            "ejb-name".equals(propertyName)) { // sunddui is using this, I have no idea why
            if (value == null || value.equals("")) {
                String fqn = (String) super.getValue("EjbClass");
                // return simple name of Java class
                    if (fqn != null){
                        return fqn.lastIndexOf(".") > -1 ? fqn.substring(fqn.lastIndexOf(".") + 1) : fqn;
                    }
            }
        } else  if ("org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity".equals(getClass().getName())) {
            if ("Name".equals(propertyName)) {
                // value is null if name attribute is not specified
                if (value == null || "".equals(value)) {
                    String fqn = super.getAttributeValue("Class2");
                    // return simple name of Java class
                    return fqn == null ? "ERROR IN ENTITY" : fqn.substring(fqn.lastIndexOf(".") + 1);
                }
            }
        }
        return value;
    }

    /**
     * Performs deep search for bean in any tree defined by the root.
     * Comparison is performed using {@link BaseBean#isEqualTo}
     * 
     * @param root root of the tree where the search will be performed
     * @param bean bean that should be found
     * @return object representing given bean in given tree o null if not found.
     */
    private static BaseBean findBean(BaseBean root, BaseBean bean) {
        Stack<BaseBean> stack = new Stack<BaseBean>();
        stack.push(bean);
        BaseBean parent = bean.parent();
        String beanRootName = bean._getRoot().name();
        while (parent != null && !beanRootName.equals(parent.name())) {
            stack.push(parent);
            parent = parent.parent();
        }
        BaseBean foundBean = findInStack(root, stack);
        return foundBean;
    }
    
    /**
     * Tries to recursively find path in parent tree.
     * 
     * @param parent root of search
     * @param stack stack of BaseBean objects representing search path
     * @return BaseBean from tree defined by parent representing BaseBean at the bottom of the stack, 
     * or null if no such BaseBean exists in tree defined by parent
     */
    private static BaseBean findInStack(BaseBean parent, Stack<BaseBean> stack) {
        if (!stack.empty()) {
            BaseBean bean = stack.pop();
            for (BaseBean child : parent.childBeans(false)) {
                if (child.isEqualTo(bean)) {
                    if (stack.isEmpty()) {
                        return child;
                    }
                    return findInStack(child, stack);
                }
            }
        }
        return null;
    }

}
