/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;

/**
 * This interface is logical unit for metadata providing.
 * Metadata can be specified in XLM descriptor (configuration file),
 * or annotations defined in Java classes. This unit is used for coupling 
 * XML-based descriptor with Java classes and it is basic key to pass to
 * DD API providers (instead of XML FileObject used in the past).
 *
 * @author Martin Adamek
 */
public interface MetadataUnit {
    
    /**
     * Provides unit's XML descriptor
     *
     * @return descriptor FileObject or null if not available
     */
    FileObject getDeploymentDescriptor();

    /**
     * Provides unit's classpath, which covers sources and libraries logically 
     * coupled with XML descriptor. Note, that if XML doesn't exist, this
     * classpath is only place where metadata comes from and it describes where 
     * can be annotated classes related to this unit found.
     *
     * @return classpath of the unit
     */
    ClassPath getClassPath();

}
