/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.schema2beans.BaseBean;

/**
 *
 * @author Martin Adamek
 */
public class MergedProvider {

    private static final MergedProvider instance = new MergedProvider();
    private Map<BaseBean, BaseBean> nn2dd = new HashMap<BaseBean, BaseBean>();
    
    private MergedProvider() {
    }
    
    public static MergedProvider getDefault() {
        return instance;
    }
    
    public Object getXmlRoot(Object nn) {
        return nn2dd.get(nn);
    }
    
    public Object getRoot(BaseBean nnRoot, BaseBean ddRoot) {
        if (nn2dd.get(nnRoot) == null && ddRoot != null) {
            nn2dd.put(nnRoot, ddRoot);
            nnRoot.merge(ddRoot, BaseBean.MERGE_UNION);
        }
        return nnRoot;
    }

}
