/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import java.lang.reflect.Field;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.classpath.ClassPathAccessor;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;

/**
 *
 * @author Andrei Badea
 */
public final class ClassPathSupport {

    private ClassPathSupport() {
    }

    public static ClassPath createWeakProxyClassPath(ClassPath[] delegates) {
        if (delegates == null) {
            throw new NullPointerException("The delegates parameter cannot be null");
        }
        ClassPathImplementation[] impls = new ClassPathImplementation[delegates.length];
        for (int i = 0; i < delegates.length; i++) {
             impls[i] = getClassPathImpl(delegates[i]);
        }
        return ClassPathFactory.createClassPath(new WeakProxyClassPathImplementation(impls));
    }

    private static ClassPathImplementation getClassPathImpl(ClassPath classPath) {
        try {
            Field field = classPath.getClass().getDeclaredField("impl"); // NOI18N
            field.setAccessible(true);
            return (ClassPathImplementation)field.get(classPath);
        } catch (SecurityException ex) {
            throw wrapException(ex);
        } catch (IllegalArgumentException ex) {
            throw wrapException(ex);
        } catch (IllegalAccessException ex) {
            throw wrapException(ex);
        } catch (NoSuchFieldException ex) {
            throw wrapException(ex);
        }
    }

    private static Error wrapException(Throwable t) {
        Error e = new AssertionError(t.getMessage());
        e.initCause(t);
        return e;
    }
}
