/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.SchemaElementUtil;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EntityGenerator;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp.*;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EjbGenerationUtil;

/**
 *
 * @author Pavel Buzek
 */
public class CmpGenerationTest extends NbTestCase {
    
    private static final String EJBJAR_XML = "ejb-jar.xml";
    private static final String DB_SCHEMA = "pointbase-samples.dbschema";
    
    private EjbJar dd;
    private FileObject dbFO;
    private FileObject ejbJarXmlFO;
    
    public CmpGenerationTest() {
        super("CmpGenerationTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(CmpGenerationTest.class);
        return suite;
    }
    
    protected void setUp() throws Exception {
        File dataDir = getDataDir();
        assertNotNull(dataDir);
        
        File ejbF = new File(dataDir.getAbsolutePath(), EJBJAR_XML);
        assertNotNull(ejbF);
        
        ejbJarXmlFO = FileUtil.toFileObject(ejbF);
        assertNotNull(ejbJarXmlFO);
        
        File dbF = new File(getDataDir().getAbsolutePath(), DB_SCHEMA);
        dbFO = FileUtil.toFileObject(dbF);
        assertNotNull(dbFO);
        
        dd = DDProvider.getDefault().getDDRoot(ejbJarXmlFO);
        assertNotNull(dd);
    }
    
    public void testGeneration() throws Exception {
        final ProgressHandle handle = ProgressHandleFactory.createHandle("test cmp");
        handle.start();
        
        RelatedCMPWizard rcmpw = new RelatedCMPWizard();
        RelatedCMPHelper helper;
        helper = new RelatedCMPHelper(dd);
        EjbGenerationUtil genHelper = helper.getGenerationHelper();
        
        String pkgName = "testPackage";
        FileObject pkg = FileUtil.toFileObject(getDataDir()).createFolder(pkgName);
        helper.setPackageName(pkgName);
        
        helper.setDbSchemaSource(true);
        SchemaElement schemaElement = SchemaElementUtil.forName(dbFO);
        helper.setDbSchemaElement(schemaElement, dbFO);
        
        String selectedTables[] = new String [] {
            "ORDER_TBL", "SALES_REP_DATA_TBL",
//in closure:  "CUSTOMER_TBL", "DISCOUNT_CODE_TBL", "MANUFACTURE_TBL", "MICRO_MARKETS_TBL",
//in closure:  "OFFICE_TBL", "OFFICE_TYPE_CODE_TBL", "PRODUCT_CODE_TBL", "PRODUCT_TBL",
//in closure:  "SALES_REP_TBL", "SALES_TAX_CODE_TBL",
        };
        helper.setSelectedTables(selectedTables);
        
        CmpGenerator generator = new CmpGenerator();
        generator.generateBeans(new ProgressPanel(), helper, pkg, dbFO, genHelper, handle, ejbJarXmlFO, null, dd, true);
        FileObject gen [] = pkg.getChildren();
        File golden = new File(getDataDir(), "golden");
        List goldenFileNames = new ArrayList(Arrays.asList(golden.list()));
        for (int i = 0; i < gen.length; i++) {
            String fname = gen[i].getNameExt();
            assertTrue("File " + fname + " was generated but was not expected.", goldenFileNames.contains(fname));
            assertFile(FileUtil.toFile(gen[i]), new File(golden, fname));
            goldenFileNames.remove(fname);
        }
        assertTrue("There are " + goldenFileNames.size() + " more golden files then generated files.", goldenFileNames.isEmpty());
    }
    
}
