/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.common.FQNSearch;
import org.openide.util.Utilities;


/**
 *
 * @author  Chris Webster
 */
public class ServiceLocatorStrategyPanel extends javax.swing.JPanel {
    
    public static final String IS_VALID = "ServiceLocatorStrategyPanel_isValid"; //NOI18N

    /** Creates new form ServiceLocatorStrategyPanel */
    public ServiceLocatorStrategyPanel(String serviceLocatorName) {
        initComponents();
        if (serviceLocatorName != null) {
            unreferencedServiceLocator.doClick();
            className.setText(serviceLocatorName);
        } else {
            noServiceLocator.doClick();
        }
        className.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                validateClass();
            }
            public void insertUpdate(DocumentEvent e) {
                validateClass();
            }
            public void removeUpdate(DocumentEvent e) {
                validateClass();
            }
        });
    }
    
    public String classSelected() {
        return (String) 
            (unreferencedServiceLocator.isSelected()?className.getText():null); 
    }

    public JRadioButton getUnreferencedServiceLocator() {
        return unreferencedServiceLocator;
    }
    
    public JTextField getClassName() {
        return className;
    }
    
    private void validateClass() {
        if (unreferencedServiceLocator.isSelected()) {
            if (Utilities.isJavaIdentifier(className.getText())) {
                firePropertyChange(IS_VALID, false, true);
            } else {
                firePropertyChange(IS_VALID, true, false);
            }
        } else {
            firePropertyChange(IS_VALID, false, true);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        noServiceLocator = new javax.swing.JRadioButton();
        unreferencedServiceLocator = new javax.swing.JRadioButton();
        className = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ServiceLocatorStrategy")));
        buttonGroup1.add(noServiceLocator);
        noServiceLocator.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(noServiceLocator, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_NoServiceLocator"));
        noServiceLocator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                noLocator(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        add(noServiceLocator, gridBagConstraints);
        noServiceLocator.getAccessibleContext().setAccessibleName("&Generator inline lookup code");
        noServiceLocator.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ServiceLocatorStrategyPanel.class, "ACSD_NoServiceLocator"));

        buttonGroup1.add(unreferencedServiceLocator);
        org.openide.awt.Mnemonics.setLocalizedText(unreferencedServiceLocator, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_UseServiceLocatorClass"));
        unreferencedServiceLocator.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                unreferencedServiceLocatorItemStateChanged(evt);
            }
        });
        unreferencedServiceLocator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                existingClassPressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        add(unreferencedServiceLocator, gridBagConstraints);
        unreferencedServiceLocator.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ServiceLocatorStrategyPanel.class, "ACSD_UseServiceLocatorClass"));

        className.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                classNameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 5);
        add(className, gridBagConstraints);
        className.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_ExistingClassName"));
        className.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_ExistingClassName"));

        jButton1.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("MN_Browse").charAt(0));
        jButton1.setText("...");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        add(jButton1, gridBagConstraints);
        jButton1.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_Browse"));
        jButton1.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("ACS_Browse"));

    }// </editor-fold>//GEN-END:initComponents

    private void classNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_classNameActionPerformed
        validateClass();
    }//GEN-LAST:event_classNameActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        className.setEnabled(true);
        unreferencedServiceLocator.setSelected(true);
        SwingUtilities.invokeLater (new Runnable() {
            public void run() {
                FQNSearch.showFastOpen(className);
            }
        });
    }//GEN-LAST:event_jButton1ActionPerformed

    private void unreferencedServiceLocatorItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_unreferencedServiceLocatorItemStateChanged
        validateClass();
    }//GEN-LAST:event_unreferencedServiceLocatorItemStateChanged

    private void noLocator(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noLocator
        disableSelectors();
    }//GEN-LAST:event_noLocator

    private void existingClassPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_existingClassPressed
        disableSelectors();
        className.setEnabled(true);
        validateClass();
    }//GEN-LAST:event_existingClassPressed
    
    private void disableSelectors() {
        className.setEnabled(false);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTextField className;
    private javax.swing.JButton jButton1;
    private javax.swing.JRadioButton noServiceLocator;
    private javax.swing.JRadioButton unreferencedServiceLocator;
    // End of variables declaration//GEN-END:variables
    
}
