/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejbcontainer;

import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.openide.actions.*;
import org.openide.nodes.*;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.Utilities;
import java.awt.Image;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

/**
 * @author Ludovic Champenois
 */
public class WebServicesNode extends AbstractNode {
    
    private static Image WEB_SERVICES_BADGE = Utilities.loadImage( "org/netbeans/modules/j2ee/ejbcore/ui/logicalview/ejbcontainer/webservicegroup.png", true ); // NOI18N
	private DataFolder srcFolder;
	
    public WebServicesNode(EjbJar model, ClassPath srcPath) {
        super(new WebServicesChildren(model, srcPath));
        setDisplayName(NbBundle.getMessage(WebServicesNode.class, "LBL_WebServices"));
        setShortDescription(NbBundle.getMessage(WebServicesNode.class, "HINT_WebServices"));

		FileObject[] roots = srcPath.getRoots();
		if(roots.length > 0 && roots[0].isFolder()) {
			srcFolder = DataFolder.findFolder(roots[0]);
		} else {
			srcFolder = null;
		}
    }
	
	public Image getIcon( int type ) {        
		return computeIcon( false, type );
	}

	public Image getOpenedIcon( int type ) {
		return computeIcon( true, type );
	}

	private Image computeIcon( boolean opened, int type ) {
		if(srcFolder != null) {
			Node folderNode = srcFolder.getNodeDelegate();
			Image image = opened ? folderNode.getOpenedIcon( type ) : folderNode.getIcon( type );
			return Utilities.mergeImages( image, WEB_SERVICES_BADGE, 7, 7 );
		} else {
			// !PW FIXME We need a guarranteed folder node resource to avoid this edge case.
			return WEB_SERVICES_BADGE;
		}
	}

    // Create the popup menu:
    public Action[] getActions(boolean context) {
        return new SystemAction[] {
            SystemAction.get(OpenLocalExplorerAction.class),
            null,
            // SystemAction.get(MyFavoriteAction.class),
            // null,                     // separator
            /* according to what it can do:
                   SystemAction.get(ReorderAction.class),
                   null,
                   SystemAction.get(CutAction.class),
                   SystemAction.get(CopyAction.class),
                   SystemAction.get(PasteAction.class),
                   null,
                   SystemAction.get(DeleteAction.class),
                   SystemAction.get(RenameAction.class),
                   null,
                   SystemAction.get(NewAction.class),
                   null,
             */
            SystemAction.get(ToolsAction.class),
            null,
            SystemAction.get(PropertiesAction.class),
        };
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
        // When you have help, change to:
        // return new HelpCtx(WebServicesNode.class);
    }
}
