/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejbcontainer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.*;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;

import org.openide.nodes.*;

/**
 * Web Services contained within a module
 * @author Chris Webster, Ludovi Champenois
 */
public class WebServicesChildren extends Children.Keys implements PropertyChangeListener {
    
    private final EjbJar model;
    private final ClassPath srcPath;
    
    public WebServicesChildren(EjbJar model, ClassPath srcPath) {
        this.model = model;
        this.srcPath = srcPath;
    }
    
    protected void addNotify() {
        super.addNotify();
        updateKeys();
        model.addPropertyChangeListener(this);
    }
    
    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                EnterpriseBeans beans = model.getEnterpriseBeans();
                List keys = Collections.EMPTY_LIST;
  /*      if (beans != null) {
            Session[] sessionBeans = beans.getSession();
            Entity[] entityBeans = beans.getEntity();
            MessageDriven[] messageBeans = null;
            messageBeans = beans.getMessageDriven();
            keys = new ArrayList(sessionBeans.length +
                                 entityBeans.length  +
                                 messageBeans.length);
            addKeyValues(keys, Arrays.asList(sessionBeans));
            addKeyValues(keys, Arrays.asList(messageBeans));
            addKeyValues(keys, Arrays.asList(entityBeans));
        } for now*/
                setKeys(keys);
            }
        });
    }
    
    protected void removeNotify() {
        model.removePropertyChangeListener(this);
        setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }
    
    protected Node[] createNodes(Object keyDelegate) {
        Object key = ((Schema2BeansKey) keyDelegate).getBean();
        return new Node[0];
    }
    
    public void propertyChange(PropertyChangeEvent pce) {
        updateKeys();
    }
    
    private void addKeyValues(List keyContainer, List beans) {
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            keyContainer.add(new Schema2BeansKey(it.next()));
        }
    }
    
    private static class Schema2BeansKey {
        private Object delegate;
        public Schema2BeansKey(Object delegate) {
            this.delegate = delegate;
        }
        
        public Object getBean() {
            return delegate;
        }
        
        public boolean equals(Object other) {
            return other != null  &&
                   other.getClass().equals(getClass()) &&
                   getBean() == ((Schema2BeansKey)other).getBean();
        }
        
        public int hashCode() {
            return System.identityHashCode(getBean());
        }
    }
}
