/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action;

import org.netbeans.modules.j2ee.ejbcore.ui.FoldersListSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Adamek
 */
public class DeleteEJBDialog extends javax.swing.JPanel {
    
    public static final String DELETE_NOTHING = "deleteNothing";
    public static final String DELETE_ONLY_DD = "deleteOnlyDD";
    public static final String DELETE_ALL = "deleteAll";
    
    private String ejbDisplayName;
    
    private DeleteEJBDialog(String ejbDisplayName) {
        this.ejbDisplayName = ejbDisplayName;
        initComponents();
        deleteClassesCheckBox.setSelected(FoldersListSettings.getDefault().isAgreedDeleteEJBGeneratedSources());
    }

    public static String open(String ejbDisplayName) {
        String title = NbBundle.getMessage(DeleteEJBDialog.class, "MSG_ConfirmDeleteObjectTitle");
        DeleteEJBDialog delDialog = new DeleteEJBDialog(ejbDisplayName);
        NotifyDescriptor desc = new NotifyDescriptor.Confirmation(delDialog, title, NotifyDescriptor.YES_NO_OPTION);
        Object result = DialogDisplayer.getDefault().notify(desc);
        if (result.equals(NotifyDescriptor.CLOSED_OPTION)) {
            return DELETE_NOTHING;
        } else if (result.equals(NotifyDescriptor.NO_OPTION)) {
            return DELETE_NOTHING;
        } else if (delDialog.deleteClassesCheckBox.isSelected()) {
            return DELETE_ALL;
        } else {
            return DELETE_ONLY_DD;
        }
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        deleteClassesCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(org.openide.util.NbBundle.getMessage(DeleteEJBDialog.class, "MSG_ConfirmDeleteObject", new Object[] {ejbDisplayName}));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        add(jLabel1, gridBagConstraints);

        deleteClassesCheckBox.setText(org.openide.util.NbBundle.getBundle(DeleteEJBDialog.class).getString("MSG_DeleteClasses"));
        deleteClassesCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteClassesCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        add(deleteClassesCheckBox, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void deleteClassesCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteClassesCheckBoxActionPerformed
        FoldersListSettings.getDefault().setAgreedDeleteEJBGeneratedSources(deleteClassesCheckBox.isSelected());
    }//GEN-LAST:event_deleteClassesCheckBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox deleteClassesCheckBox;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
}
