/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/** Action 
 *
 * @author Chris Webster
 * @author Martin Adamek
 */
abstract class AbstractExposeMethodAction extends NodeAction {
    
    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; i++) {
           expose(JMIUtils.getMethodFromNode(nodes[i]));
        }
    }
    
    protected abstract boolean canExpose(Method me);
    protected abstract void expose(Method me);
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected boolean asynchronous() {
        return false;
    }
    
    protected boolean enable(Node[] nodes) {
        return allNodesCanPromote(nodes);
    }

    private boolean allNodesCanPromote(Node[] nodes) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            for (int i = 0; i < nodes.length; i++) {
                Collection/*<Object>*/ lookupIt = nodes[i].getLookup().lookup(new Lookup.Template(Method.class)).allInstances();
                if (lookupIt.isEmpty()) {
                    return false;
                }
                Iterator/*<Object>*/ it = lookupIt.iterator();
                while (it.hasNext()) {
                    Method item = (Method)it.next();
                    boolean signatureOk = 
                            Modifier.isPublic(item.getModifiers()) &&
                            !Modifier.isStatic(item.getModifiers());
                    boolean canPromote = signatureOk && canExpose(item);
                    if (!canPromote) {
                        return false;
                    }
                }
            }
            return true;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }
    
    protected void initialize() {
         super.initialize();
         putProperty(Action.SHORT_DESCRIPTION, NbBundle.getMessage(AbstractExposeMethodAction.class, "HINT_Action"));
    }
    
    public javax.swing.Action createContextAwareInstance(org.openide.util.Lookup actionContext) {
        boolean enable = enable((Node[])actionContext.lookup (new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]));
        return enable ? super.createContextAwareInstance(actionContext) : null;
    }
}
