/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;


/**
 *
 * @author Martin Adamek
 */
public class Utils {
    
    private Utils() {
    }

    public static Method[] getMethods(EjbMethodController c, boolean checkLocal, boolean checkRemote) {
        List methods = new ArrayList();
        List features;
        features = c.getBeanClass().getFeatures();
        for(int i = 0; i < features.size(); i++){
            Object o = features.get(i);
            if (o instanceof Method) {
                methods.add(o);
            }
        }
        Iterator iter;
        if (checkLocal) {
            iter = c.getLocalInterfaces().iterator();
            while (iter.hasNext()) {
                JavaClass interfaceCE = (JavaClass) iter.next();
                features = interfaceCE.getFeatures();
                for(int i = 0; i < features.size(); i++){
                    Object o = features.get(i);
                    if (o instanceof Method) {
                        methods.add(o);
                    }
                }
            }
        }
        if (checkRemote) {
            iter = c.getRemoteInterfaces().iterator();
            while (iter.hasNext()) {
                JavaClass interfaceCE = (JavaClass) iter.next();
                features = interfaceCE.getFeatures();
                for(int i = 0; i < features.size(); i++){
                    Object o = features.get(i);
                    if (o instanceof Method) {
                        methods.add(o);
                    }
                }
            }
        }
        Method[] methodsArray = (Method[]) methods.toArray(new Method[methods.size()]);
        return methodsArray;
    }
    
}
