/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-200? Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.ejbcore.ui;

import java.io.File;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;


public class FoldersListSettings extends SystemOption {

    static final long serialVersionUID = 4387056038180083587L;
    
    private static final String AGREED_DELETE_EJB_GENERATED_SOURCES = "agreeDeleteEJBGeneratedSources"; // NOI18N
    private static final String AGREED_CREATE_SERVER_RESOURCES = "agreeCreateServerResources"; // NOI18N

    public String displayName() {
        return NbBundle.getMessage (FoldersListSettings.class, "TXT_EjbCoreFolderList"); //NOI18N
    }

    public static FoldersListSettings getDefault () {
        return (FoldersListSettings) SystemOption.findObject (FoldersListSettings.class, true);
    }

    public boolean isAgreedDeleteEJBGeneratedSources() {
        Boolean b = (Boolean)getProperty(AGREED_DELETE_EJB_GENERATED_SOURCES);
        return b == null ? false : b.booleanValue();
    }
    
    public void setAgreedDeleteEJBGeneratedSources(boolean agreed) {
        this.putProperty(AGREED_DELETE_EJB_GENERATED_SOURCES, Boolean.valueOf(agreed), true);
    }
    
    public boolean isAgreedCreateServerResources() {
        Boolean b = (Boolean)getProperty(AGREED_CREATE_SERVER_RESOURCES);
        return b == null ? true : b.booleanValue();
    }
    
    public void setAgreedCreateServerResources(boolean agreed) {
        this.putProperty(AGREED_CREATE_SERVER_RESOURCES, Boolean.valueOf(agreed), true);
    }
}
