/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.ejbcore.hints;

import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.ExposeInLocalAction;
import org.openide.util.NbBundle;

/**
 *
 * @author Pavel Buzek
 */
public class ExposeMethodHint extends Hint {

    public static final int LOCAL = 0;
    public static final int REMOTE = 1;
    
    private static final String LBL_LOCAL = NbBundle.getMessage(ExposeInLocalAction.class, "LBL_PromoteToLocal");
    private static final String LBL_REMOTE = NbBundle.getMessage(ExposeInLocalAction.class, "LBL_PromoteToRemote");
    
    Method method;
    int exposeIn;
    
    /** Creates a new instance of ExposeInLocalHint */
    public ExposeMethodHint(Method method, int exposeIn) {
        this.method = method;
        this.exposeIn = exposeIn;
    }
    
    public ChangeInfo implement() {
        if (exposeIn == LOCAL) {
            Utils.exposeInLocal(method);
        }
        if (exposeIn == REMOTE) {
            Utils.exposeInRemote(method);
        }
        return null;
    }
    
    public int getType() {
        return SUGGESTION;
    }
    
    public String getText() {
        return exposeIn == LOCAL ? LBL_LOCAL : LBL_REMOTE;
    }
}
