/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.earproject.ui;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.UpdateHelper;
import org.netbeans.modules.j2ee.earproject.ui.actions.AddModuleAction;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

/**
 * Provides a logical view of a Enterprise Application Project.
 *
 * @author  vkraemer
 */
public final class LogicalViewProvider extends J2eeArchiveLogicalViewProvider {
    
    private final EarProject earProject;
    private final static List<SystemAction> specialActions = 
            Collections.singletonList(SystemAction.get(AddModuleAction.class));
    
    /** Creates a new instance of EarLogicalViewProvider */
    public LogicalViewProvider(EarProject earProject, UpdateHelper helper,
            PropertyEvaluator evaluator, ReferenceHelper resolver,
            AntBasedProjectType abpt) {
        super(earProject, helper, evaluator, resolver, specialActions, abpt);
        this.earProject = earProject;
    }
    
    public Node createLogicalView() {
        Node retVal = super.createLogicalView();
        Children kids = retVal.getChildren();
        kids.add(new Node[] { new LogicalViewNode(helper.getAntProjectHelper()) });
        return retVal;
    }
    
    public Node findPath(Node root, Object target) {
        // XXX this is incorrect - must handle case that target instanceof DataObject
        // (since that is likely to be what is in lookup)
        FileObject pd = earProject.getProjectDirectory();
        if (pd.equals(target)) {
            return root;
        }
        Node retVal = super.findPath(root, target);
        if (null != retVal) {
            return retVal;
        }
        if (!(target instanceof FileObject)) {
            return retVal;
        }
        
        // check to see if this target could be a submodule
        Project p = FileOwnerQuery.getOwner((FileObject) target);
        if (null == p) {
            return retVal;
        }
//        Node[] nodes = root.getChildren().getNodes(true);
//        for (int i = nodes.length-1; i >= 0; i--) {
//            if (nodes[i] instanceof ModuleNode) {
//                ModuleNode mn = (ModuleNode) nodes[i];
//            }
//        }
        return retVal;
    }
    
}
