/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarCustomizer;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/** 
 * Customization of Enterprise Application project.
 *
 * @author Petr Hrebejk
 */
public class EarCustomizerProvider implements CustomizerProvider {
    
    private final Project project;
    private final AntProjectHelper antProjectHelper;   
    private final ReferenceHelper refHelper;
    private final AntBasedProjectType abpt;
    
    // Option indexes
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = OPTION_OK + 1;
    
    // Option command names
    private static final String COMMAND_OK = "OK";          // NOI18N
    private static final String COMMAND_CANCEL = "CANCEL";  // NOI18N
     
    public EarCustomizerProvider(Project project, AntProjectHelper antProjectHelper, ReferenceHelper refHelper, AntBasedProjectType abpt) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = refHelper;
        this.abpt = abpt;
    }
            
    public void showCustomizer() {
        createDialog().setVisible(true);
    }
    
    Dialog createDialog() {
        // Create options
        JButton options[] = new JButton[] {
            new JButton( NbBundle.getMessage( EarCustomizerProvider.class, "LBL_Customizer_Ok_Option") ), // NOI18N
            new JButton( NbBundle.getMessage( EarCustomizerProvider.class, "LBL_Customizer_Cancel_Option" ) ) , // NOI18N
        };
        
        // Set commands
        options[ OPTION_OK ].setActionCommand( COMMAND_OK );
        options[ OPTION_CANCEL ].setActionCommand( COMMAND_CANCEL );
        
        // RegisterListener
        EarProjectProperties earProperties = new EarProjectProperties( (EarProject)project, refHelper, abpt );
        ActionListener optionsListener = new OptionListener( project, earProperties );
        options[ OPTION_OK ].addActionListener( optionsListener );
        options[ OPTION_CANCEL ].addActionListener( optionsListener );
        
        ProjectEar pwm = (ProjectEar) project.getLookup().lookup(ProjectEar.class);
        
        EarCustomizer innerPane = new EarCustomizer(earProperties, pwm); // , preselectedNodeName);
        DialogDescriptor dialogDescriptor = new DialogDescriptor(
                innerPane, // new EarCustomizer(earProperties, pwm), // innerPane
                NbBundle.getMessage( EarCustomizerProvider.class, "LBL_Customizer_Title" , // displayName
                ProjectUtils.getInformation(project).getDisplayName() ),
                false,                                  // modal
                options,                                // options
                options[OPTION_OK],                     // initial value
                DialogDescriptor.BOTTOM_ALIGN,          // options align
                null,                                   // helpCtx
                null );                                 // listener
        
        innerPane.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.setClosingOptions( new Object[] { options[ OPTION_OK ], options[ OPTION_CANCEL ] } );
        
        return DialogDisplayer.getDefault().createDialog(dialogDescriptor);
    }
    
    /** Listens to the actions on the Customizer's option buttons */
    private static class OptionListener implements ActionListener {
    
        private Project project;
        private EarProjectProperties earProperties;
        
        OptionListener( Project project, EarProjectProperties earProperties ) {
            this.project = project;
            this.earProperties = earProperties;            
        }
        
        public void actionPerformed( ActionEvent e ) {
            String command = e.getActionCommand();
            
            if (COMMAND_OK.equals(command)) {
                // Store the properties 
                earProperties.store();
            }
            
        }        
        
    }
                            
}
