/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;

/**
 * Editor panel for selecting security roles.
 *
 * @author  ptliu
 */
public class SecurityRolesEditorPanel extends javax.swing.JPanel {
    
    /** Creates new form SecurityRolesEditorPanel */
    public SecurityRolesEditorPanel(String [] allRoles, String[] selectedRoles) {
        initComponents();
        
        initTable(allRolesTable, getRemainingRoles(allRoles, selectedRoles),
                NbBundle.getMessage(SecurityConstraintPanel.class,"LBL_AllSecurityRoles"));
        initTable(selectedRolesTable, selectedRoles,
                NbBundle.getMessage(SecurityConstraintPanel.class,"LBL_AllSecurityRoles"));
    }
    
    public String[] getSelectedRoles() {
        DefaultTableModel model = (DefaultTableModel) selectedRolesTable.getModel();
        int rowCount = model.getRowCount();
        String[] selectedRoles = new String[rowCount];
        
        for (int i = 0; i < rowCount; i++) {
            selectedRoles[i] = (String) model.getValueAt(i, 0);
        }
        
        return selectedRoles;
    }
    
    private void initTable(JTable table, String[] data, String columnName) {
        DefaultTableModel model = new DefaultTableModel() {
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        
        model.addColumn(columnName);
         
        for (int i = 0; i < data.length; i++) {
            model.addRow(new Object[] {data[i]});
        }
        
        table.setModel(model);
    }
        
    private String[] getRemainingRoles(String[] allRoles, String[] selectedRoles) {
        ArrayList result = new ArrayList();
        
        for (int i = 0; i < allRoles.length; i++) {
            String roleName = allRoles[i];
            boolean found = false;
            
            for (int j = 0; j < selectedRoles.length; j++) {
                if (roleName.equals(selectedRoles[j])) {
                    found = true;
                    break;
                }
            }
            
            if (!found) result.add(roleName);
        }
        
        String[] remainingRoles = new String[result.size()];
        return (String[]) result.toArray(remainingRoles);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        allRolesTable = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        selectedRolesTable = new javax.swing.JTable();

        addButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_AddSecurityRole"));
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        removeButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_RemoveSecurityRole"));
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        allRolesTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(allRolesTable);

        selectedRolesTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane2.setViewportView(selectedRolesTable);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(addButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(removeButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 246, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(layout.createSequentialGroup()
                            .add(83, 83, 83)
                            .add(addButton)
                            .add(35, 35, 35)
                            .add(removeButton))
                        .add(layout.createSequentialGroup()
                            .addContainerGap()
                            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 246, Short.MAX_VALUE))))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
// TODO add your handling code here:
        int[] selectedRows = selectedRolesTable.getSelectedRows();
        DefaultTableModel allRolesTableModel = (DefaultTableModel) allRolesTable.getModel();
        DefaultTableModel selectedRolesTableModel = (DefaultTableModel) selectedRolesTable.getModel();
        
        // Get the list of selected role names
        for (int i = 0; i < selectedRows.length; i++) {
            String roleName = (String) selectedRolesTableModel.getValueAt(selectedRows[i], 0);
            allRolesTableModel.addRow(new Object[] {roleName});
        }
        
        // Now remove the selected rows from the allRolesTable
        for (int i = selectedRows.length-1; i >=0; i--) {
            selectedRolesTableModel.removeRow(selectedRows[i]);
        }
    }//GEN-LAST:event_removeButtonActionPerformed

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
// TODO add your handling code here:
        int[] selectedRows = allRolesTable.getSelectedRows();
        DefaultTableModel allRolesTableModel = (DefaultTableModel) allRolesTable.getModel();
        DefaultTableModel selectedRolesTableModel = (DefaultTableModel) selectedRolesTable.getModel();
        
        // Get the list of selected role names
        for (int i = 0; i < selectedRows.length; i++) {
            String roleName = (String) allRolesTableModel.getValueAt(selectedRows[i], 0);
            selectedRolesTableModel.addRow(new Object[] {roleName});
        }
        
        // Now remove the selected rows from the allRolesTable
        for (int i = selectedRows.length-1; i >=0; i--) {
            allRolesTableModel.removeRow(selectedRows[i]);
        }
    }//GEN-LAST:event_addButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JTable allRolesTable;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton removeButton;
    private javax.swing.JTable selectedRolesTable;
    // End of variables declaration//GEN-END:variables
    
}
