/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;

/**
 * Panel for display the run-as element of the servlet deployment descriptor.
 * @author  ptliu
 */
public class RunAsPanel extends javax.swing.JPanel {
    private WebApp webApp;
    
    /** Creates new form RunAsPanel */
    public RunAsPanel(final WebApp webApp) {
        initComponents();
        
        this.webApp = webApp;
        
        webApp.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent event) {
                //System.out.println("source = " + event.getSource());
                
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                
                //System.out.println("oldValue = " + oldValue);
                //System.out.println("newValue = " + newValue);
                
                String selectedItem = (String) runAsCB.getSelectedItem();
                if (oldValue instanceof SecurityRole ||
                        newValue instanceof SecurityRole) {
                    initModel(webApp.getSecurityRole());
                }
                runAsCB.setSelectedItem(selectedItem);
            }
        });
        
        initModel(webApp.getSecurityRole());
    }
    
    private void initModel(SecurityRole[] roles) {
        String[] roleNames = new String[roles.length+1];
        roleNames[0] = "";      //NOI18N
        
        for (int i = 0; i < roles.length; i++) {
            roleNames[i+1] = roles[i].getRoleName();
        }
        runAsCB.setModel(new DefaultComboBoxModel(roleNames));
        
        runAsCB.setSelectedIndex(0);      
    }
    
    public String getRunAs() {
        return (String) runAsCB.getSelectedItem();
    }
    
    public JComboBox getRunAsCB() {
        return runAsCB;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        runAsLabel = new javax.swing.JLabel();
        runAsCB = new javax.swing.JComboBox();

        setOpaque(false);
        runAsLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_runAs_mnem").charAt(0));
        runAsLabel.setLabelFor(runAsCB);
        runAsLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_RunAs"));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(runAsLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(runAsCB, 0, 358, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(runAsLabel)
                    .add(runAsCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox runAsCB;
    private javax.swing.JLabel runAsLabel;
    // End of variables declaration//GEN-END:variables
    
}
