/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.ddloaders.web.*;
import org.netbeans.modules.xml.multiview.ui.*;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.api.project.SourceGroup;
import org.openide.util.NbBundle;

/**
 * @author  mkuchtiak
 */
public class FilterPanel extends SectionInnerPanel {
    private DDDataObject dObj;
    private Filter filter;
    private javax.swing.JButton linkButton;
    private FilterParamsPanel filterParamsPanel;
    private FilterMappingsTablePanel filterMappingsPanel;
    
    /** Creates new form FilterPanel */
    public FilterPanel(SectionView sectionView, DDDataObject dObj,Filter filter) {
        super(sectionView);
        this.dObj=dObj;
        this.filter=filter;
        initComponents();

        // Filter Name
        filterNameTF.setText(filter.getFilterName());
        addValidatee(filterNameTF);
        
        // description
        Utils.makeTextAreaLikeTextField(descriptionTA,filterNameTF);
        descriptionTA.setText(filter.getDefaultDescription());
        addModifier(descriptionTA);
        

        // Init Params
        InitParamTableModel model = new InitParamTableModel();
        filterParamsPanel = new FilterParamsPanel(dObj, model);
        filterParamsPanel.setModel(filter,filter.getInitParam());       
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 0, 0);
        add(filterParamsPanel, gridBagConstraints);
        
        filterClassTF.setText(filter.getFilterClass());
        addValidatee(filterClassTF);
 
        linkButton = new LinkButton(this, filter, "ClassName"); //NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        linkButton.setText(NbBundle.getMessage(FilterPanel.class, "LBL_goToSource"));
        add(linkButton, gridBagConstraints);
        setAccessibility();
    }
    
    private void setAccessibility() {
        linkButton.setMnemonic(NbBundle.getMessage(FilterPanel.class, "LBL_goToSource_mnem").charAt(0));
        filterParamsLabel.setLabelFor(filterParamsPanel.getTable());
    }
    
    public void linkButtonPressed(Object ddBean, String property) {
        if ("ClassName".equals(property)) { // NOI18N
            DDUtils.openEditorFor(dObj,((Filter)ddBean).getFilterClass());
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        filterNameLabel = new javax.swing.JLabel();
        filterNameTF = new javax.swing.JTextField();
        descriptionLabel = new javax.swing.JLabel();
        descriptionTA = new javax.swing.JTextArea();
        filterClassLabel = new javax.swing.JLabel();
        filterClassTF = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        filler = new javax.swing.JPanel();
        filterParamsLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        filterNameLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_filterName_mnem").charAt(0));
        filterNameLabel.setLabelFor(filterNameTF);
        filterNameLabel.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_filterName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 10);
        add(filterNameLabel, gridBagConstraints);

        filterNameTF.setColumns(30);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(filterNameTF, gridBagConstraints);

        descriptionLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_description_mnem").charAt(0));
        descriptionLabel.setLabelFor(descriptionTA);
        descriptionLabel.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_description"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 10);
        add(descriptionLabel, gridBagConstraints);

        descriptionTA.setRows(3);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(descriptionTA, gridBagConstraints);

        filterClassLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_filterClass_mnem").charAt(0));
        filterClassLabel.setLabelFor(filterClassTF);
        filterClassLabel.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_filterClass"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 10);
        add(filterClassLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(filterClassTF, gridBagConstraints);

        browseButton.setMnemonic(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_browse_mnem").charAt(0));
        browseButton.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_browse"));
        browseButton.setMargin(new java.awt.Insets(0, 14, 0, 14));
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 0, 0);
        add(browseButton, gridBagConstraints);

        filler.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(filler, gridBagConstraints);

        filterParamsLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_initParams_mnem").charAt(0));
        filterParamsLabel.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "LBL_initParams"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 0, 0);
        add(filterParamsLabel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        // TODO add your handling code here:
        try {
            SourceGroup[] groups = DDUtils.getJavaSourceGroups(dObj);
            org.openide.filesystems.FileObject fo = BrowseFolders.showDialog(groups);
            if (fo!=null) {
                String className = DDUtils.getResourcePath(groups,fo);
                if (className.length()>0 && !className.equals(filterClassTF.getText())) {
                    dObj.modelUpdatedFromUI();
                    dObj.setChangedFromUI(true);
                    filterClassTF.setText(className);
                    filter.setFilterClass(className);
                    dObj.setChangedFromUI(false);
                    getSectionView().checkValidity();
                }
            }
        } catch (java.io.IOException ex) {}
    }//GEN-LAST:event_browseButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JTextArea descriptionTA;
    private javax.swing.JPanel filler;
    private javax.swing.JLabel filterClassLabel;
    private javax.swing.JTextField filterClassTF;
    private javax.swing.JLabel filterNameLabel;
    private javax.swing.JTextField filterNameTF;
    private javax.swing.JLabel filterParamsLabel;
    // End of variables declaration//GEN-END:variables
    
    public javax.swing.JComponent getErrorComponent(String name) {
        if ("FilterName".equals(name)) return filterNameTF; //NOI18N
        else if ("FilterClass".equals(name)) return filterClassTF; //NOI18N
        return null;
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
        if (comp==filterNameTF) {
            String val = (String)value;
            if (val.length()==0) {
                getSectionView().getErrorPanel().setError(new Error(Error.MISSING_VALUE_MESSAGE, "Filter Name",filterNameTF));
                return;
            }
            Filter[] filters = dObj.getWebApp().getFilter();
            for (int i=0;i<filters.length;i++) {
                if (filter!=filters[i] && val.equals(filters[i].getFilterName())) {
                    getSectionView().getErrorPanel().setError(new Error(Error.TYPE_FATAL, Error.DUPLICATE_VALUE_MESSAGE, val, filterNameTF));
                    return;
                }
            }
            getSectionView().getErrorPanel().clearError();
        } else if (comp==filterClassTF) {
            String text = (String)value;
            if (text.length()==0) {
                getSectionView().getErrorPanel().setError(new Error(Error.MISSING_VALUE_MESSAGE, "Filter Class",filterClassTF));
                return;
            }
            getSectionView().getErrorPanel().clearError();
        }
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        if (source==filterNameTF) {
            String text = (String)value;
            // change Filter-mappings
            FilterMapping[] maps = DDUtils.getFilterMappings(dObj.getWebApp(), filter);
            for (int i=0;i<maps.length;i++) {
                maps[i].setFilterName(text);
            }
            // change Filter-name
            filter.setFilterName(text);
            //change panel title, node name
            SectionPanel enclosingPanel = getSectionView().findSectionPanel(filter);
            enclosingPanel.setTitle(((FiltersMultiViewElement.FiltersView)getSectionView()).getFilterTitle(filter));
            enclosingPanel.getNode().setDisplayName(text);
        } else if (source==filterClassTF) {
            String text = (String)value;
            filter.setFilterClass(text.length()==0?null:text);
        } else if (source==descriptionTA) {
            String text = (String)value;
            filter.setDescription(text.length()==0?null:text);
        }
    }
    
    public void rollbackValue(javax.swing.text.JTextComponent source) {
        if (source==filterNameTF) {
            filterNameTF.setText(filter.getFilterName());
        } else if (source==filterClassTF) {
            filterClassTF.setText(filter.getFilterClass());
        }
    }
    
    /** This will be called before model is changed from this panel
     */
    protected void startUIChange() {
        dObj.setChangedFromUI(true);
    }
    
    /** This will be called after model is changed from this panel
     */
    protected void endUIChange() {
        dObj.modelUpdatedFromUI();
        dObj.setChangedFromUI(false);
    }
    
 }
