/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.dd.impl.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbBuilderUtil;
import org.netbeans.modules.j2ee.metadata.NNModelBuilder;
import org.netbeans.modules.j2ee.metadata.Utils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;

/**
 * Annotation listener implementation for Servlet 2.5 Metadata
 *
 * @author Marek Fukala
 */
public class WebNNListener extends NNModelBuilder {
    
    /** A map storing annotations to model structure mapping. */
    private Map<String,String> nn2ModelMapping;
    
    private WebApp webApp;
    private ClassPath cp;
    
    //mappings
    private static final String ENV_ENTRY = "EnvEntry#EnvEntryName=$MEMBER;!name=EnvEntryName;!type=EnvEntryType";
    private static final String SERVICE_REF_ENTRY = "ServiceRef#ServiceRefName=$JAVA_CLASS-MEMBER;!name=ServiceRefName";
    
    private static final String RES_REF_ENTRY = "ResourceRef#ResType=$MEMBERCLASS;ResRefName=$MEMBER;!name=ResRefName;!type=ResType";

    private static final String RES_ENV_REF_ENTRY = "ResourceEnvRef#ResourceEnvRefName=$MEMBER;!name=ResourceEnvRefName;!type=ResourceEnvRefType";
    private static final String MSG_DEST_ENTRY = "MessageDestinationRef#MessageDestinationRefName=$MEMBER;!name=MessageDestinationRefName";
    
    //annotations
    private static final String RESOURCE_NN = "javax.annotation.Resource";
    private static final String JAVAX_ANNOTATION_WEBSERVICEREF = "javax.xml.ws.WebServiceRef";
    
    private static final String RES_KEY_PART = RESOURCE_NN + "#" +MEMBER_CLASS_REF+"=";
    
    //custom handling code constants
    private static final String WS_PKG = "javax.xml.ws.";
    private static final String WS_SERVICE_CLASS_NAME = "Service";
    private static final String WS_ENDPOINT_CLASS_NAME = "Endpoint";
    
    
    public WebNNListener(WebApp webapp, ClassPath cp) {
        super((BaseBean)webapp);
        this.webApp = webapp;
        this.cp = cp;
        initNN2ModelMapping();
    }
    
    public ClassPath getClassPath() {
        return cp;
    }
    
    private void initNN2ModelMapping() {
        nn2ModelMapping = new HashMap();
        //WebApp wa;wa.getEjbRef(0).set
        
        //<env-entry> element mappings
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.String", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Character", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Integer", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Boolean", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Double", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Byte", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Short", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Long", ENV_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "java.lang.Float", ENV_ENTRY);
        
        //<service-ref>
        nn2ModelMapping.put(RES_KEY_PART + "javax.xml.rpc.Service", SERVICE_REF_ENTRY);
        
        //@WebServiceRef -> <service-ref> mapping
        nn2ModelMapping.put(JAVAX_ANNOTATION_WEBSERVICEREF, SERVICE_REF_ENTRY + ";!wsdlLocation=WsdlFile;!value=<CUSTOM>;!type=<CUSTOM>");
        
        //<resource-ref>
        nn2ModelMapping.put(RES_KEY_PART + "javax.sql.DataSource", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.jms.ConnectionFactory", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.jms.QueueConnectionFactory", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.jms.TopicConnectionFactory", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.mail.Session", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.net.URL", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.resource.cci.ConnectionFactory", RES_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "org.omg.CORBA_2_3.ORB", RES_REF_ENTRY);
        
        //XXX any other connection factory jsdefined by a resource adapter?!?!?
        
        //<message-destination-ref>
        nn2ModelMapping.put(RES_KEY_PART + "javax.jms.Queue", MSG_DEST_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.jms.Topic", MSG_DEST_ENTRY);
        
        //<resource-env-ref>
        nn2ModelMapping.put(RES_KEY_PART + "javax.resource.cci.InteractionSpec", RES_ENV_REF_ENTRY);
        nn2ModelMapping.put(RES_KEY_PART + "javax.transaction.UserTransaction", RES_ENV_REF_ENTRY);
        //everything else is also <resource-env-ref>
        //nn2ModelMapping.put(RES_KEY_PART + "java.lang.Object", RES_ENV_REF_ENTRY);
        
        //@WebServiceRef -> <service-ref> mapping
        //nn2ModelMapping.put(JAVAX_ANNOTATION_WEBSERVICEREF, SERVICE_REF_ENTRY);
        
        //<ejb-ref> handled directly on event
        nn2ModelMapping.put("javax.ejb.EJB", "");
        
    }
    
    public Collection<String> getPrimaryAnnotations() {
        return Collections.EMPTY_LIST;
    }
    
    public Map<String,String> getAnnotation2ModelMapping() {
        return nn2ModelMapping;
    }
    
    //    public void addClassAnnotation(JavaClass javaClass, Annotation annotation) {
    //        super.addClassAnnotation(javaClass, annotation);
    //        ddRoot.dumpXml();
    //    }
    
    @Override
    public void addMemberAnnotation(boolean field, JavaClass javaClass, Element member, Annotation annotation, AnnotationType annotationType) {
        String annotationClass = annotationType.getName();
        if (EjbBuilderUtil.JAVAX_EJB_EJB.equals(annotationClass)) {
            Session session = EjbBuilderUtil.findReferencedSessionBean((TypedElement) member, annotation);
            if (session != null) {
                if (EjbBuilderUtil.exposesLocalInterface(session, ((TypedElement) member).getType().getName())) {
                    nn2ModelMapping.put(EjbBuilderUtil.JAVAX_EJB_EJB, "/EjbLocalRef#EjbRefName=$JAVA_CLASS-MEMBER;!name=EjbRefName");
                } else {
                    nn2ModelMapping.put(EjbBuilderUtil.JAVAX_EJB_EJB, "/EjbRef#EjbRefName=$JAVA_CLASS-MEMBER;!name=EjbRefName");
                }
            }
        }
        super.addMemberAnnotation(field, javaClass, member, annotation, annotationType);
        
        //more complicated cases are handled here
        if(JAVAX_ANNOTATION_WEBSERVICEREF.equals(annotationClass)) {
            webServiceRefNNAdded(javaClass, member, annotation);
        }
        
        //        ddRoot.dumpXml();
    }
    
    public void classRemoved(String fqn) {
        // do nothing?
    }
    
    // ============= custom annotations handling code =============
    
    private void webServiceRefNNAdded(JavaClass javaClass, Element member, Annotation annotation) {
        //The default framework creates the ServiceRef element
        //and sets the ServiceRefName and WsdlFile properties
        //
        //Now the special cases described in JSR-109 specifications needs to be handled:
        
        //At first, find the <service-ref> bean
        ServiceRef sref = null;
        try {
            String elementName = ((NamedElement)member).getName();
            String javaClassName = javaClass.getName();
            ServiceRef[] srefs = (ServiceRef[])webApp.getServiceRef();
            if(srefs != null) {
                for(ServiceRef sr : srefs) {
                    if(getServiceRefName(elementName, javaClassName).equals(sr.getServiceRefName())) {
                        sref = sr;
                        break;
                    }
                }
            }
        } catch (VersionNotSupportedException e) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
        }
        if(sref == null) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, new IllegalStateException("<service-ref> element not defined for member " + ((NamedElement)member).getName() + " in class " + javaClass.getName()));
            return ;
        }
        
        JavaModelPackage jmp = (JavaModelPackage)javaClass.refImmediatePackage();
        Type _ServiceType = jmp.getJavaClass().resolve(WS_PKG + WS_SERVICE_CLASS_NAME);
        Type _EndpointType = jmp.getJavaClass().resolve(WS_PKG + WS_ENDPOINT_CLASS_NAME);
        
        JavaClass typeJC = null;
        JavaClass valueJC = null;
        
        //get annotation member type
        if(member instanceof Field) {
            typeJC = (JavaClass)((Field)member).getTypeName().getElement();
        }
        
        //get the java classes from attribute values
        for(AttributeValue av : (List<AttributeValue>)annotation.getAttributeValues()) {
            String aName = av.getDefinition().getName();
            InitialValue val = av.getValue();
            if(val instanceof ClassExpression) {
                TypeReference tr = ((ClassExpression)val).getClassName();
                JavaClass jc = (JavaClass)tr.getElement();
                
                if("type".equals(aName)) {
                    typeJC = jc;
                }
                if("value".equals(aName)) {
                    valueJC = jc;
                }
            } else if ("wsdlLocation".equals(aName)){
                try {
                    String uri = Utils.stringValue(av);
                    sref.setWsdlFile(new URI(uri));
                } catch (URISyntaxException ex) {
                    ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
                }
            }
            
        }
        
        //<service-ref>/<service-interface>
        if(valueJC == null && typeJC != null) {
            //= @WebServiceRef.type (annotation declares a Service)
            sref.setServiceInterface(typeJC.getName());
        }
        
        if(typeJC != null && Utils.isOfType(typeJC, _EndpointType)) {
            //= @WebServiceRef.value
            if(valueJC != null) {
                sref.setServiceInterface(valueJC.getName());
            } else {
                //                System.out.println("@WebServiceRef.value is empty!!!");
            }
        }
        
        //<service-ref>/<port-component-ref>/<service-endpoint-interface>
        if(valueJC != null && Utils.isOfType(valueJC, _ServiceType)) {
            PortComponentRef pcr;
            try {
                pcr = sref.newPortComponentRef();
                pcr.setServiceEndpointInterface(typeJC.getName());
                sref.addPortComponentRef(pcr);
            } catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
        
        //<service-ref>/<service-ref-type> = @WebServiceRef.type
        //there doesn't seem to be <service-ref-type> property in the current schema!?!?
    }
    
    private String getServiceRefName(String memberName, String javaClass) {
        return javaClass + "/" + memberName;
    }
    
}
