/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.j2ee.appclient;

import java.io.IOException;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;

/**
 *
 * @author kolard
 */
public class AppClientFunctionalTest extends DbJellyTestCase
{
    public static String PROJECT_LOCATION=System.getProperty("xtest.tmpdir");
    public static String PROJECT_NAME="myappclient";
    
    /** Creates a new instance of AppClientFunctionalTest */
    public AppClientFunctionalTest (String s)
    {
        super (s);
    }
    public void testCreateAppClientProject () throws IOException
    {
        
        debug("testCreateAppClientProject");
        //debug("tmp project location:" + PROJECT_LOCATION);
        NewProjectWizardOperator projectWizard = NewProjectWizardOperator.invoke();
        
        String category = Bundle.getStringTrimmed (
                "org.netbeans.modules.j2ee.clientproject.ui.wizards.Bundle",
                "Templates/Project/J2EE/emptyCar.xml");
        projectWizard.selectCategory("Enterprise");
        projectWizard.selectProject ("Enterprise Application Client");
        projectWizard.next ();
        debug("desc=" + projectWizard.getName());
        NewEnterpriseApplicationClient etc = new NewEnterpriseApplicationClient();
        
        String pathS = etc.getProjectName();
        debug("project name:" + pathS);
        etc.setProjectName("**" + pathS);
        debug("project name:" + etc.getProjectName());
        debug("error:" + etc.lblProjectNameIsNotAValidFolderName().getText());
        etc.setProjectName(pathS + PROJECT_NAME);
        debug("project name:" + etc.getProjectName());
        
        String mainS = etc.getMainClass();
        debug("mainclass:" + mainS);
        etc.setMainClass(mainS + "**");
        debug("mainclass:" + etc.getMainClass());
        debug("error:" + etc.lblMainClassNameIsNotValid().getText());
        etc.setMainClass(mainS);
        debug("mainclass:" + etc.getMainClass());
        
        String folderS = etc.getProjectLocation();
        debug("project folder:" + folderS);
        etc.setProjectLocation(folderS + "***");
        debug("project folder:" + etc.getProjectLocation());
        debug("error:" + etc.lblProjectFolderIsNotAValidPath().getText());
        etc.setProjectLocation(folderS);
        debug("project folder:" + etc.getProjectLocation());
        
        projectWizard.finish ();
        debug("wizard finished");
        sleep (1000);
        ProjectSupport.waitScanFinished ();
    }
    
    public void testJsfBeanWizzard()
    {
        NewFileWizardOperator projectWizard = NewFileWizardOperator.invoke();
        String filetype = Bundle.getStringTrimmed(
                "org/netbeans/modules/web/jsf/resources/Bundle",
                "Templates/JSP_Servlet/JSFManagedBean.java");
        projectWizard.selectCategory("Web");
        projectWizard.selectFileType(filetype);
        projectWizard.next();
        NewJSFBeanStepOperator bean=new NewJSFBeanStepOperator();
        bean.setClassName("MyManagedBean");
        bean.selectScope("session");
        bean.finish();
        new EditorOperator("MyManagedBean.java").close();
        
        
    }

    
    /** Test new project wizard using generic WizardOperator. */
    public void testGenericWizards() {
        
        debug("starting testGenericWizards");
        // open new project wizard
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        npwo.selectCategory("Web");
        npwo.selectProject("Web Application");
        npwo.next();
        // create operator for next page
        WizardOperator wo = new WizardOperator("Web Application");
        new JTextFieldOperator(wo, 0).typeText("MyApp1234");
        new JTextFieldOperator(wo, 1).setText(System.getProperty("user.home"));
        // finish wizard
        wo.finish();
    }

        public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        System.out.println("---suite---");
        suite.addTest(new AppClientFunctionalTest("testCreateAppClientProject"));
        //suite.addTest(new AppClientFunctionalTest("testGenericWizards"));
        return suite;
    }

    
    static class NewWebProjectFrameworkStep extends NewProjectWizardOperator
    {
        private JTableOperator _tabFrameworks;
        
        public JTableOperator tabFrameworks ()
        {
            if (_tabFrameworks==null)
            {
                _tabFrameworks = new JTableOperator (this);
            }
            return _tabFrameworks;
        }
        
    } 
        
    }
