/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.clientproject.ui.wizards;

import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.clientproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.openide.modules.SpecificationVersion;

/**
 * Displays a warning that the project's Java platform will be set to JDK 1.4 or
 * the source level will be set to 1.4. Similarly for 1.5. See issue #55797.
 *
 * @author Andrei Badea
 */
public final class J2eeVersionWarningPanel extends javax.swing.JPanel {
    
    /**
     * Display a warning that the target platform will be downgraded to JDK 1.4
     */
    public final static String WARN_SET_JDK_14 = "warnSetJdk14"; // NOI18N
    
    /**
     * Display a warning that the target platform will be upgraded to JDK 1.5
     */
    public final static String WARN_SET_JDK_15 = "warnSetJdk15"; // NOI18N
    
    /**
     * Display a warning that the source level will be downgraded to 1.4
     */
    public final static String WARN_SET_SOURCE_LEVEL_14 = "warnSetSourceLevel14"; // NOI18N
    
    /**
     * Display a warning that the source level will be upgraded to 1.5
     */
    public final static String WARN_SET_SOURCE_LEVEL_15 = "warnSetSourceLevel15"; // NOI18N
    
    private String warningType;
    private String javaPlatformName;
    
    public J2eeVersionWarningPanel(String warningType) {
        initComponents();
        setWarningType(warningType);
    }
    
    public String getWarningType() {
        return warningType;
    }
    
    public void setWarningType(String warningType) {
        this.warningType = warningType;
        
        setJdk14Panel.setVisible(false);
        setSourceLevel14Panel.setVisible(false);
        setJdk15Panel.setVisible(false);
        setSourceLevel15Panel.setVisible(false);
        
        if (WARN_SET_JDK_14.equals(warningType)) {
            setJdk14Panel.setVisible(true);
            downgradeJdk14CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetJdk14());
        } else if (WARN_SET_SOURCE_LEVEL_14.equals(warningType)) {
            setSourceLevel14Panel.setVisible(true);
            downgradeSourceLevel14CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetSourceLevel14());
        } else if (WARN_SET_JDK_15.equals(warningType)) {
            setJdk15Panel.setVisible(true);
            downgradeJdk15CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetJdk15());
        } else if (WARN_SET_SOURCE_LEVEL_15.equals(warningType)) {
            setSourceLevel15Panel.setVisible(true);
            downgradeSourceLevel15CheckBox.setSelected(FoldersListSettings.getDefault().isAgreedSetSourceLevel15());
        }
    }
    
    public boolean getDowngradeAllowed() {
        if (WARN_SET_JDK_14.equals(warningType)) {
            return downgradeJdk14CheckBox.isSelected();
        } else if (WARN_SET_SOURCE_LEVEL_14.equals(warningType)) {
            return downgradeSourceLevel14CheckBox.isSelected();
        } else if (WARN_SET_JDK_15.equals(warningType)) {
            return downgradeJdk15CheckBox.isSelected();
        } else if (WARN_SET_SOURCE_LEVEL_15.equals(warningType)) {
            return downgradeSourceLevel15CheckBox.isSelected();
        } else return false;
    }
    
    public String getSuggestedJavaPlatformName() {
        if (javaPlatformName == null && WARN_SET_JDK_14.equals(warningType) ) {
            JavaPlatform[] java14Platforms = getJavaPlatforms("1.4");
            javaPlatformName = java14Platforms[0].getDisplayName();
        }
        if (javaPlatformName == null && WARN_SET_JDK_15.equals(warningType) ) {
            JavaPlatform[] java14Platforms = getJavaPlatforms("1.5");
            javaPlatformName = java14Platforms[0].getDisplayName();
        }
        return javaPlatformName;
    }
    
    public static String findWarningType(String j2eeLevel) {
//        System.out.println("findWarningType: j2eeLevel="+j2eeLevel);
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion version = defaultPlatform.getSpecification().getVersion();
//        System.out.println("default platform is "+version);
        
        // no warning if 1.4 is the default for j2ee14
        if (new SpecificationVersion("1.4").equals(version) && j2eeLevel.equals(J2eeModule.J2EE_14)) // NOI18N
            return null;
        
        // no warning if 1.5 is the default for j2ee15
        if (new SpecificationVersion("1.5").equals(version) && j2eeLevel.equals(J2eeModule.JAVA_EE_5)) // NOI18N
            return null;
        
        if (j2eeLevel.equals(J2eeModule.J2EE_14)) {
            JavaPlatform[] java14Platforms = getJavaPlatforms("1.4"); //NOI18N
            if (java14Platforms.length > 0) {
                // the user has JDK 1.4, so we warn we'll downgrade to 1.4
                return WARN_SET_JDK_14;
            } else {
                // no JDK 1.4, the best we can do is downgrade the source level to 1.4
                return WARN_SET_SOURCE_LEVEL_14;
            }
        } else {
            assert j2eeLevel.equals(J2eeModule.JAVA_EE_5);
            JavaPlatform[] java15Platforms = getJavaPlatforms("1.5"); //NOI18N
            if (java15Platforms.length > 0) {
                // the user has JDK 1.5, so we warn we'll downgrade to 1.5
                return WARN_SET_JDK_15;
            } else {
                // no JDK 1.5, the best we can do is downgrade the source level to 1.5
                return WARN_SET_SOURCE_LEVEL_15;
            }
        }
    }
    
    private static JavaPlatform[] getJavaPlatforms(String level) {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification("J2SE", new SpecificationVersion(level))); // NOI18N
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        setJdk14Panel = new javax.swing.JPanel();
        warningJdk14TextArea = new javax.swing.JTextArea();
        downgradeJdk14CheckBox = new javax.swing.JCheckBox();
        setSourceLevel15Panel = new javax.swing.JPanel();
        warningSourceLevel15TextArea = new javax.swing.JTextArea();
        downgradeSourceLevel15CheckBox = new javax.swing.JCheckBox();
        setJdk15Panel = new javax.swing.JPanel();
        warningJdk15TextArea = new javax.swing.JTextArea();
        downgradeJdk15CheckBox = new javax.swing.JCheckBox();
        setSourceLevel14Panel = new javax.swing.JPanel();
        warningSourceLevel14TextArea = new javax.swing.JTextArea();
        downgradeSourceLevel14CheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        setJdk14Panel.setLayout(new java.awt.GridBagLayout());

        warningJdk14TextArea.setEditable(false);
        warningJdk14TextArea.setLineWrap(true);
        warningJdk14TextArea.setText(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetJdk14"));
        warningJdk14TextArea.setWrapStyleWord(true);
        warningJdk14TextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        setJdk14Panel.add(warningJdk14TextArea, gridBagConstraints);

        downgradeJdk14CheckBox.setMnemonic(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "MNE_AgreeSetJdk14").charAt(0));
        downgradeJdk14CheckBox.setSelected(true);
        downgradeJdk14CheckBox.setText(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "CTL_AgreeSetJdk14"));
        downgradeJdk14CheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        downgradeJdk14CheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downgradeJdk14CheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        setJdk14Panel.add(downgradeJdk14CheckBox, gridBagConstraints);
        downgradeJdk14CheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetJdk14"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(setJdk14Panel, gridBagConstraints);

        setSourceLevel15Panel.setLayout(new java.awt.GridBagLayout());

        warningSourceLevel15TextArea.setEditable(false);
        warningSourceLevel15TextArea.setLineWrap(true);
        warningSourceLevel15TextArea.setText(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetSourceLevel15"));
        warningSourceLevel15TextArea.setWrapStyleWord(true);
        warningSourceLevel15TextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        setSourceLevel15Panel.add(warningSourceLevel15TextArea, gridBagConstraints);

        downgradeSourceLevel15CheckBox.setMnemonic(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "MNE_AgreeSetSourceLevel15").charAt(0));
        downgradeSourceLevel15CheckBox.setSelected(true);
        downgradeSourceLevel15CheckBox.setText(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "CTL_AgreeSetSourceLevel15"));
        downgradeSourceLevel15CheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        downgradeSourceLevel15CheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downgradeSourceLevel15CheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        setSourceLevel15Panel.add(downgradeSourceLevel15CheckBox, gridBagConstraints);
        downgradeSourceLevel15CheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetSourceLevel15"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(setSourceLevel15Panel, gridBagConstraints);

        setJdk15Panel.setLayout(new java.awt.GridBagLayout());

        warningJdk15TextArea.setEditable(false);
        warningJdk15TextArea.setLineWrap(true);
        warningJdk15TextArea.setText(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetJdk15"));
        warningJdk15TextArea.setWrapStyleWord(true);
        warningJdk15TextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        setJdk15Panel.add(warningJdk15TextArea, gridBagConstraints);

        downgradeJdk15CheckBox.setMnemonic(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "MNE_AgreeSetJdk15").charAt(0));
        downgradeJdk15CheckBox.setSelected(true);
        downgradeJdk15CheckBox.setText(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "CTL_AgreeSetJdk15"));
        downgradeJdk15CheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        downgradeJdk15CheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downgradeJdk15CheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        setJdk15Panel.add(downgradeJdk15CheckBox, gridBagConstraints);
        downgradeJdk15CheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetJdk15"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(setJdk15Panel, gridBagConstraints);

        setSourceLevel14Panel.setLayout(new java.awt.GridBagLayout());

        warningSourceLevel14TextArea.setEditable(false);
        warningSourceLevel14TextArea.setLineWrap(true);
        warningSourceLevel14TextArea.setText(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetSourceLevel14"));
        warningSourceLevel14TextArea.setWrapStyleWord(true);
        warningSourceLevel14TextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        setSourceLevel14Panel.add(warningSourceLevel14TextArea, gridBagConstraints);

        downgradeSourceLevel14CheckBox.setMnemonic(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "MNE_AgreeSetSourceLevel14").charAt(0));
        downgradeSourceLevel14CheckBox.setSelected(true);
        downgradeSourceLevel14CheckBox.setText(org.openide.util.NbBundle.getMessage(J2eeVersionWarningPanel.class, "CTL_AgreeSetSourceLevel14"));
        downgradeSourceLevel14CheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        downgradeSourceLevel14CheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downgradeSourceLevel14CheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        setSourceLevel14Panel.add(downgradeSourceLevel14CheckBox, gridBagConstraints);
        downgradeSourceLevel14CheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetSourceLevel14"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(setSourceLevel14Panel, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void downgradeSourceLevel15CheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downgradeSourceLevel15CheckBoxActionPerformed
        FoldersListSettings.getDefault().setAgreedSetSourceLevel15(downgradeSourceLevel15CheckBox.isSelected());
    }//GEN-LAST:event_downgradeSourceLevel15CheckBoxActionPerformed

    private void downgradeJdk15CheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downgradeJdk15CheckBoxActionPerformed
        FoldersListSettings.getDefault().setAgreedSetJdk15(downgradeJdk15CheckBox.isSelected());
    }//GEN-LAST:event_downgradeJdk15CheckBoxActionPerformed

    private void downgradeSourceLevel14CheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downgradeSourceLevel14CheckBoxActionPerformed
        FoldersListSettings.getDefault().setAgreedSetSourceLevel14(downgradeSourceLevel14CheckBox.isSelected());
    }//GEN-LAST:event_downgradeSourceLevel14CheckBoxActionPerformed

    private void downgradeJdk14CheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downgradeJdk14CheckBoxActionPerformed
        FoldersListSettings.getDefault().setAgreedSetJdk14(downgradeJdk14CheckBox.isSelected());
    }//GEN-LAST:event_downgradeJdk14CheckBoxActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox downgradeJdk14CheckBox;
    private javax.swing.JCheckBox downgradeJdk15CheckBox;
    private javax.swing.JCheckBox downgradeSourceLevel14CheckBox;
    private javax.swing.JCheckBox downgradeSourceLevel15CheckBox;
    private javax.swing.JPanel setJdk14Panel;
    private javax.swing.JPanel setJdk15Panel;
    private javax.swing.JPanel setSourceLevel14Panel;
    private javax.swing.JPanel setSourceLevel15Panel;
    private javax.swing.JTextArea warningJdk14TextArea;
    private javax.swing.JTextArea warningJdk15TextArea;
    private javax.swing.JTextArea warningSourceLevel14TextArea;
    private javax.swing.JTextArea warningSourceLevel15TextArea;
    // End of variables declaration//GEN-END:variables
    
}

