/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.blueprints.ui;

/**
 * Base class for tab panels that appear on the main BluePrints panel.  
 * This provides common functionality such as saving / restoring
 * the current scroll position.
 *
 * @author Mark Roth
 */
public abstract class BluePrintsTabPanel extends javax.swing.JPanel {

    /** Creates new form BluePrintsTabPanel */
    public BluePrintsTabPanel(BluePrintsPanel bluePrintsPanel) {
        this.bluePrintsPanel = bluePrintsPanel;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        setLayout(new java.awt.BorderLayout());
        
    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    /** The panel that contains this tab */
    protected BluePrintsPanel bluePrintsPanel;
    
    /**
     * Returns the current scroll position so that when the user navigates
     * to a new article we can keep track of where the user was in this tab.
     *
     * @return The current scroll position in this tab.
     */
    public abstract int getScrollPosition();
    
    /**
     * Sets the current scroll position so that when the user uses the
     * Back or Forward button we can return the user to where they
     * were reading before they left off.
     *
     * @param scrollPosition The scroll position in this tab.
     */
    public abstract void setScrollPosition(int scrollPosition);

    /**
     * Called when the tab needs to be updated because a new article has
     * been selected.
     */
    public abstract void updateTab();
}
