package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.windows.TopComponent;

class RelativeSizeScrollPane extends JScrollPane implements Constants{

    private float relativeHeight;
    private int minHeight;

    public RelativeSizeScrollPane( JComponent c, float relativeHeight, int minHeight ) {
        super( c );
        this.relativeHeight = relativeHeight;
        this.minHeight = minHeight;
    }

    public Dimension getPreferredSize() {
        Dimension retValue = super.getPreferredSize();
        
        Component parent = getParent();
        while (null != parent) {
            if (parent instanceof TopComponent) {
                retValue.height = (int) ((parent.getSize().height-GRAPHICS_TOTAL_VERTICAL_HEIGHT) * relativeHeight);
                if( retValue.height < minHeight )
                    retValue.height = minHeight;
            }
            parent = parent.getParent();
        }
        return retValue;
    }

}