/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.welcome.content;

import java.awt.Graphics;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

/**
 * The default container for Start Page content.
 *
 * @author S. Aubrecht
 */
class DefaultContentPane extends JPanel {
    
    private BackgroundPainter painter;
    
    /** Creates a new instance of ContentPane */
    public DefaultContentPane( ComponentDescriptor[] contents, BackgroundPainter painter ) {
        super( new GridBagLayout() );
        
        setOpaque( false );
        setFocusable( false );
        
        this.painter = painter;
        
        for( int i=0; i<contents.length; i++ ) {
            add( contents[i].construct(), contents[i].getConstraints() );
        }
    }

    protected void paintComponent(Graphics g) {
        if( null != painter )
            painter.paintComponent( this, g );
    }
}
