/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.welcome.content;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

/**
 *
 * @author S. Aubrecht
 */
class DefaultComponentDescriptor extends ComponentDescriptor {
    
    /** Creates a new instance of DefaultComponentInfo */
    public DefaultComponentDescriptor( String id ) {
        super( id );
    }
    
    public Component construct() {
        try {
            String clz = getClassName();
            if (clz != null) {
                return (Component)loadClass(clz).newInstance();
            }
            else {
                return newFromFactory(getMethod());
            }
            
        } catch( Exception e ) {
            ErrorManager.getDefault().notify( ErrorManager.INFORMATIONAL, e );
        }
        return new JLabel( "<html>Cannot create component from <br>" + getClassName() ); // NOI18N
    }
    
    private Class loadClass(final String clz) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup( ClassLoader.class );
        if( null == loader )
            loader = ClassLoader.getSystemClassLoader();
        
        Class clazz = Class.forName( clz, true, loader );
        return clazz;
    }
    
    private Component newFromFactory (String methodName) 
            throws ClassNotFoundException, NoSuchMethodException, 
            IllegalAccessException, InvocationTargetException {
        assert methodName != null: "neither class name nor factory method is specified in "+this;
        int idx = methodName.lastIndexOf('.');
        Class clz = loadClass( methodName.substring(0, idx));
        Method m = clz.getMethod(methodName.substring(idx+1), new Class[] {});
        Object obj = m.invoke(null, new Object [] {});
        return (Component)obj;
    }
}
