/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.welcome.content;

import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.xml.parsers.ParserConfigurationException;
import org.openide.ErrorManager;
import org.xml.sax.SAXException;

/**
 * A factory class to create content for IDE's Start Page
 *
 * @author S. Aubrecht
 */
public class ContentFactory {
    
    private ContentFactory() {
    }
    
    /**
     * Create default Start Page content from layout XML file defined in this module's layer.
     *
     * @return Content component to be displayed in IDE's Start Page.
     */
    public static JComponent createContentPane() {
        ContentParser parser = new ContentParser();
        try {
            
            parser.parseLocal();
            JScrollPane scroll = new JScrollPane( new DefaultContentPane( parser.getContents(), parser.getBackgroundPainter() ) );
            scroll.setFocusable( false );
            scroll.setBorder( BorderFactory.createEmptyBorder() );
            return scroll;
            
        } catch( IOException ioE ) {
            ErrorManager.getDefault().notify( ErrorManager.INFORMATIONAL, ioE );
        } catch( SAXException saxE ) {
            ErrorManager.getDefault().notify( ErrorManager.INFORMATIONAL, saxE );
        } catch( ParserConfigurationException pcE ) {
            ErrorManager.getDefault().notify( ErrorManager.INFORMATIONAL, pcE );
        }
        return new JLabel( BundleSupport.getLabel( "ErrParsingLayout" ) ); // NOI18N
    }
}
