/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package validation;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import junit.textui.TestRunner;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.FavoritesOperator;
import org.netbeans.jellytools.FilesTabOperator;
import org.netbeans.jellytools.HelpOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.NewFileNameLocationStepOperator;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.NewProjectNameLocationStepOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.OptionsOperator;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jellytools.OutputTabOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jellytools.TreeTableOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.AttachWindowAction;
import org.netbeans.jellytools.actions.CompileAction;
import org.netbeans.jellytools.actions.CopyAction;
import org.netbeans.jellytools.actions.CutAction;
import org.netbeans.jellytools.actions.DeleteAction;
import org.netbeans.jellytools.actions.NewFileAction;
import org.netbeans.jellytools.actions.PasteAction;
import org.netbeans.jellytools.actions.ViewAction;
import org.netbeans.jellytools.modules.debugger.actions.ContinueAction;
import org.netbeans.jellytools.modules.debugger.actions.DebugAction;
import org.netbeans.jellytools.modules.debugger.actions.FinishDebuggerAction;
import org.netbeans.jellytools.modules.debugger.actions.ToggleBreakpointAction;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.JavaNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.SourcePackagesNode;
import org.netbeans.jellytools.properties.Property;
import org.netbeans.jellytools.properties.PropertySheetOperator;

import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JSpinnerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.PNGEncoder;

import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Overall validation suite for IDE.
 *
 * @author Jiri.Skrivanek@sun.com
 */
public class IDEValidation extends JellyTestCase {
    
    /** Need to be defined because of JUnit */
    public IDEValidation(String name) {
        super(name);
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new IDEValidation("testMainMenu"));
        suite.addTest(new IDEValidation("testHelp"));
        suite.addTest(new IDEValidation("testOptions"));
        suite.addTest(new IDEValidation("testOptionsClassicView"));
        suite.addTest(new IDEValidation("testNewProject"));
        // sample project must exist before testShortcuts
        suite.addTest(new IDEValidation("testShortcuts"));
        suite.addTest(new IDEValidation("testNewFile"));
        suite.addTest(new IDEValidation("testCVSLite"));
        suite.addTest(new IDEValidation("testProjectsView"));
        suite.addTest(new IDEValidation("testFilesView"));
        suite.addTest(new IDEValidation("testEditor"));
        suite.addTest(new IDEValidation("testBuildAndRun"));
        suite.addTest(new IDEValidation("testDebugging"));
        suite.addTest(new IDEValidation("testJUnit"));
        suite.addTest(new IDEValidation("testXML"));
        suite.addTest(new IDEValidation("testWebApplication"));
        suite.addTest(new IDEValidation("testUpdateCenter"));
        suite.addTest(new IDEValidation("testDb"));
        suite.addTest(new IDEValidation("testWindowSystem"));
        suite.addTest(new IDEValidation("testSeparateWindowsMode"));
        suite.addTest(new IDEValidation("testModuleInstallation"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        TestRunner.run(suite());
        // run only selected test case
        //junit.textui.TestRunner.run(new IDEValidation("testMainMenu"));
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        // Close help window if any - it should not stay open between test cases.
        // Otherwise it can break next tests.
        closeHelpWindow();
    }
    
    public void tearDown() {
    }
    
    // name of class created from template and used in tests
    private static final String JAVA_CLASS_NAME = "Main"; // NOI18N
    // name of sample frame created and used in tests
    private static final String SAMPLE_FRAME_NAME = "SampleFrame"; // NOI18N
    // name of sample project
    private static final String SAMPLE_PROJECT_NAME = "SampleProject"; // NOI18N
    // name of first sample package
    private static final String SAMPLE1_PACKAGE_NAME = "sample1"; //NOI18N
    // name of second sample package
    private static final String SAMPLE2_PACKAGE_NAME = "sample2"; //NOI18N
    // name of sample class
    private static final String SAMPLE1_CLASS_NAME = "SampleClass1"; // NOI18N
    // name of sample file
    private static final String SAMPLE1_FILE_NAME = SAMPLE1_CLASS_NAME+".java"; // NOI18N
    // name of sample class 2
    private static final String SAMPLE2_CLASS_NAME = "SampleClass2"; // NOI18N
    // name of sample file 2
    private static final String SAMPLE2_FILE_NAME = SAMPLE2_CLASS_NAME+".java"; // NOI18N
    // name of sample web application project
    private static final String SAMPLE_WEB_PROJECT_NAME = "SampleWebProject";  //NOI18N

    /** Test creation of java project. 
     * - open New Project wizard from main menu (File|New Project)
     * - select Java Application project from Standard category
     * - in the next panel type project name and project location in
     * - finish the wizard
     * - wait until project appears in projects view
     * - wait classpath scanning finished
     */
    public void testNewProject() {
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        // "Standard"
        String standardLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle", "Templates/Project/Standard");
        npwo.selectCategory(standardLabel);
        // "Java Application"
        String javaApplicationLabel = Bundle.getStringTrimmed("org.netbeans.modules.java.j2seproject.ui.wizards.Bundle", "Templates/Project/Standard/emptyJ2SE.xml");
        npwo.selectProject(javaApplicationLabel);
        npwo.next();
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        npnlso.txtProjectName().setText(SAMPLE_PROJECT_NAME);
        npnlso.txtProjectLocation().setText(System.getProperty("netbeans.user")); // NOI18N
        npnlso.finish();
        // wait project appear in projects view
        new ProjectsTabOperator().getProjectRootNode(SAMPLE_PROJECT_NAME);
        // wait classpath scanning finished
        ProjectSupport.waitScanFinished();
    }
    
    /** Test new file wizard. 
     * - open New File wizard from main menu (File|New File)
     * - select sample project as target
     * - select Java Classes|Java Package file type
     * - in the next panel type package name in
     * - finish the wizard
     * - open New File wizard from context menu on created package node (New|File)
     * - select Java Classes|Java Main Class file type
     * - in the next panel type class name in
     * - finish the wizard
     * - check class is open in editor and close all opened documents
     */
    public void testNewFile() {
        // create a new package
        // "Java Classes"
        String javaClassesLabel = Bundle.getString("org.netbeans.modules.java.Bundle", "Templates/Classes");
        // "Java Package"
        String packageLabel = Bundle.getString("org.netbeans.modules.java.Bundle", "Templates/Classes/Package");
        NewFileWizardOperator.create(SAMPLE_PROJECT_NAME, javaClassesLabel, packageLabel, null, SAMPLE1_PACKAGE_NAME);
        // wait package node is created
        Node sample1Node = new Node(new SourcePackagesNode(SAMPLE_PROJECT_NAME), SAMPLE1_PACKAGE_NAME);
        
        // create a new classes
        
        // "Java Main Class"
        String mainClassLabel = Bundle.getString("org.netbeans.modules.java.Bundle", "Templates/Classes/Main.java"); // NOI18N
        NewFileWizardOperator.invoke(sample1Node, javaClassesLabel, mainClassLabel);
        NewFileNameLocationStepOperator nameStepOper = new NewFileNameLocationStepOperator();
        nameStepOper.setObjectName(SAMPLE1_CLASS_NAME);
        nameStepOper.finish();
        // check class is opened in Editor
        new EditorOperator(SAMPLE1_FILE_NAME);
        NewFileWizardOperator.invoke(sample1Node, javaClassesLabel, mainClassLabel);
        nameStepOper = new NewFileNameLocationStepOperator();
        nameStepOper.setObjectName(SAMPLE2_CLASS_NAME);
        nameStepOper.finish();
        // check class is opened in Editor and then close all documents
        new EditorOperator(SAMPLE2_FILE_NAME).closeAllDocuments();
    }
    
    /** Test Projects view 
     * - expand java elements hierarchy of sample class (SampleClass1.java|class SampleClass1|Methods|main) 
     * and select main method node.
     * - copy sample class and paste it to the same package
     * - verify creation of SampleClass1_1.java node
     * - cut SampleClass1_1.java
     * - paste it to another package
     * - uncheck preview refactoring changes in move dialog
     * - confirm refactoring dialog
     * - delete SampleClass1_1.java node
     */
    public void testProjectsView() {
        ProjectsTabOperator projectsTabOper = ProjectsTabOperator.invoke();
        // needed for slower machines
        JemmyProperties.setCurrentTimeout("JTreeOperator.WaitNextNodeTimeout", 30000); // NOI18N
        // "class"
        String classLabel = Bundle.getStringTrimmed("org.openide.src.nodes.Bundle", "SHORT_classElementFormat");
        // "Methods"
        String methodsLabel = Bundle.getString("org.openide.src.nodes.Bundle", "Methods");
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        Node sample1Node = new Node(sourcePackagesNode, SAMPLE1_PACKAGE_NAME);
        Node sampleClass1Node = new Node(sample1Node, SAMPLE1_FILE_NAME);
        // expand class members
        new Node(sampleClass1Node, classLabel+SAMPLE1_CLASS_NAME+"|"+methodsLabel+"|main").select(); // NOI18N
        // test pop-up menu actions
        // "Copy"
        CopyAction copyAction = new CopyAction();
        copyAction.perform(sampleClass1Node);
        // "Paste"
        PasteAction pasteAction = new PasteAction();
        pasteAction.perform(sample1Node);
        Node sampleClass1_1Node = new Node(sample1Node, "_1"); // NOI18N
        sampleClass1_1Node.select();
        // "Cut"
        CutAction cutAction = new CutAction();
        cutAction.perform(sampleClass1_1Node);
        // package created by default when the sample project was created
        Node sampleProjectPackage = new Node(sourcePackagesNode, SAMPLE_PROJECT_NAME.toLowerCase());
        new ActionNoBlock(null, pasteAction.getPopupPath()).perform(sampleProjectPackage);
        // cancel refactoring
        // "Move Class"
        String moveClassTitle = Bundle.getString("org.netbeans.modules.refactoring.ui.Bundle", "LBL_MoveClass");
        NbDialogOperator moveClassDialog = new NbDialogOperator(moveClassTitle);
        // "Preview All Changes"
        String previewLabel = Bundle.getStringTrimmed("org.netbeans.modules.refactoring.spi.ui.Bundle", "CTL_PreviewAll");
        JCheckBoxOperator previewCheckBox = new JCheckBoxOperator(moveClassDialog, previewLabel);
        if(previewCheckBox.isSelected()) {
            previewCheckBox.push();
        }
        // "Next >"
        String nextLabel = Bundle.getStringTrimmed("org.netbeans.modules.refactoring.spi.ui.Bundle", "CTL_Next");
        new JButtonOperator(moveClassDialog, nextLabel).push();
        // "Delete"
        sampleClass1_1Node = new Node(sampleProjectPackage, "_1"); // NOI18N
        DeleteAction deleteAction = new DeleteAction();
        deleteAction.perform(sampleClass1_1Node);
        // "Confirm Object Deletion"
        String confirmTitle = Bundle.getString("org.openide.explorer.Bundle", "MSG_ConfirmDeleteObjectTitle"); // NOI18N
        new NbDialogOperator(confirmTitle).yes();
    }

    /** Test Files view 
     * - expand java elements hierarchy of sample class (SampleClass1.java|class SampleClass1|Methods|main) 
     * and select main method node.
     */
    public void testFilesView() {
        FilesTabOperator filesTabOper = FilesTabOperator.invoke();
        // needed for slower machines
        JemmyProperties.setCurrentTimeout("JTreeOperator.WaitNextNodeTimeout", 30000); // NOI18N
        // "class"
        String classLabel = Bundle.getStringTrimmed("org.openide.src.nodes.Bundle", "SHORT_classElementFormat");
        // "Methods"
        String methodsLabel = Bundle.getString("org.openide.src.nodes.Bundle", "Methods");
        Node sourcePackagesNode = new Node(filesTabOper.getProjectNode(SAMPLE_PROJECT_NAME), "src"); // NOI18N
        Node sample1Node = new Node(sourcePackagesNode, SAMPLE1_PACKAGE_NAME); // NOI18N
        Node sampleClass1Node = new Node(sample1Node, SAMPLE1_FILE_NAME);
        // expand class members
        new Node(sampleClass1Node, classLabel+SAMPLE1_CLASS_NAME+"|"+methodsLabel+"|main").select(); // NOI18N
        // It is possible to test also pop-up menu actions as in testProjectsView, but
        // it is redundant IMO
    }

    
    /** Test of DB module.
     * It only tests whether the Databases node is present in Runtime view, 
     * Add Driver action is enabled on Drivers node and Connect action is available
     * on default JDBC-ODBC Bridge node.
     * - find Databases|Drivers node in Runtime tab
     * - open and close Add Driver dialog from context menu on Drivers node
     * - open and close Connect Using dialog on JDBC-ODBC Bridge node
     */
    public void testDb() {
        // "Databases"
        String databasesLabel = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "NDN_Databases");
        Node databasesNode = new Node(RuntimeTabOperator.invoke().getRootNode(), databasesLabel);
        // "Please wait..."
        String waitNodeLabel = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "WaitNode");
        // wait until the wait node dismiss and after that start waiting for Drivers node
        // (see issue http://www.netbeans.org/issues/show_bug.cgi?id=43910 - Creation of 
        // children under Databases node is not properly synchronized)
        long oldTimeout = JemmyProperties.getCurrentTimeout("Waiter.WaitingTime");
        try {
            databasesNode.waitChildNotPresent(waitNodeLabel);
        } catch (JemmyException e) {
            // Ignore and try to continue. Sometimes it happens "Please, wait" node
            // is still available (maybe some threading issue).
            log("Timeout expired: "+e.getMessage());
        }
        // "Drivers"
        String driversLabel = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "NDN_Drivers");
        Node driversNode = new Node(RuntimeTabOperator.invoke().getRootNode(), databasesLabel+"|"+driversLabel);
        // "Add Driver ..."
        String addDriverItem = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "AddNewDriver");
        // open a dialog to add a new JDBC driver
        new ActionNoBlock(null, addDriverItem).perform(driversNode);
        String addDriverTitle = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "AddDriverDialogTitle");
        new NbDialogOperator(addDriverTitle).cancel();
        
        // wait until the wait node dismiss and after that start waiting for JDBC_ODBC Bridge node
        // (see issue http://www.netbeans.org/issues/show_bug.cgi?id=43910 - Creation of 
        // children under Databases node is not properly synchronized)
        try {
            driversNode.waitChildNotPresent(waitNodeLabel);
        } catch (JemmyException e) {
            // Ignore and try to continue. Sometimes it happens "Please, wait" node
            // is still available (maybe some threading issue).
            log("Timeout expired: "+e.getMessage());
        }
        // node JDBC-ODBC Bridge should be present always
        Node jdbcOdbcNode = new Node(driversNode, "JDBC-ODBC Bridge"); // NOI18N
        // "Connect Using ..."
        String connectUsingItem = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "ConnectUsing");
        // open a dialog to create a new connection
        new ActionNoBlock(null, connectUsingItem).perform(jdbcOdbcNode);
        String newDatabaseConnectionTitle = Bundle.getString("org.netbeans.modules.db.resources.Bundle", "NewConnectionDialogTitle");
        new NbDialogOperator(newDatabaseConnectionTitle).cancel();
    }
    
    /** Test Help 
     * - open Help window from main menu (Help|Help Contents)
     */
    public void testHelp() {
        // increasing time because opening of help window can last longer on slower machines
        JemmyProperties.setCurrentTimeout("JMenuOperator.PushMenuTimeout", 60000);
        // open "Help|Contents"
        HelpOperator helpOper = HelpOperator.invoke();
        // check help window opened
        // title is "Help - All"
        helpOper.close();
    }
    
    /** Test Main Menu 
     * - close Welcome screen to not harm menu actions
     * - open and close About dialog (main menu item Help|About)
     * - open and close Javadoc Index Search top component (main menu item View|Javadoc Index Search)
     */
    public void testMainMenu() {
        // close Welcome screen to not harm menu actions
        // "Welcome
        String welcomeTitle = Bundle.getString("org.netbeans.modules.welcome.Bundle", "LBL_Tab_Title");
        new TopComponentOperator(welcomeTitle).close();
        // open About dialog
        String helpItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Help"); 
        String aboutItem = Bundle.getStringTrimmed("org.netbeans.core.actions.Bundle", "About");
        new ActionNoBlock(helpItem+"|"+aboutItem, null).perform();
        String aboutTitle = Bundle.getString("org.netbeans.core.startup.Bundle", "CTL_About_Title");
        new NbDialogOperator(aboutTitle).close();
        // open Window|Javadoc Index Search
        String viewItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        String javadocItem = Bundle.getStringTrimmed("org.netbeans.modules.javadoc.search.Bundle", "CTL_SEARCH_MenuItem");
        new Action(viewItem+"|"+javadocItem, null).perform();
        // "Javadoc Index Search"
        String javadocTitle = Bundle.getString("org.netbeans.modules.javadoc.search.Bundle", "CTL_SEARCH_WindowTitle");
        new TopComponentOperator(javadocTitle).close();
    }
    
    /** Test global shortcuts. 
     * - open and close new file wizard (CTRL+N)
     * - open and close Javadoc Index Search top component (Shift+F1)
     * - open and close new breakpoint dialog (Ctrl+Shift+F8)
     */
    public void testShortcuts() {
        // "Javadoc Index Search"
        String javadocTitle = Bundle.getString("org.netbeans.modules.javadoc.search.Bundle", 
                                               "CTL_SEARCH_WindowTitle");
        // test global shortcuts
        // open new wizard (Ctrl+N)
        Node node = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        // push Escape key to ensure there is no thing blocking shortcut execution
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);
        NewFileAction newFileAction = new NewFileAction();
        try {
            newFileAction.performShortcut(node);
            new NewFileWizardOperator().close();
            // On some linux it may happen autorepeat is activated and it 
            // opens dialog multiple times. So, we need to close all modal dialogs.
            // See issue http://www.netbeans.org/issues/show_bug.cgi?id=56672.
            closeAllModal();
        } catch (TimeoutExpiredException e) {
            // need to be realiable test => repeat action once more to be sure it is problem in IDE
            // this time use events instead of Robot
            node.select();
            MainWindowOperator.getDefault().pushKey(KeyEvent.VK_N, KeyEvent.CTRL_MASK);
            new NewFileWizardOperator().close();
        }
        // open Javadoc Index Search (Shift+F1)
        Action searchAction = new Action(null, null, new Action.Shortcut(KeyEvent.VK_F1, KeyEvent.SHIFT_MASK));
        try {
            searchAction.perform(MainWindowOperator.getDefault());
            new TopComponentOperator(javadocTitle).close();
        } catch (TimeoutExpiredException e) {
            // need to be realiable test => repeat action once more to be sure it is problem in IDE
            // this time use events instead of Robot
            MainWindowOperator.getDefault().pushKey(KeyEvent.VK_F1, KeyEvent.SHIFT_MASK);
            new TopComponentOperator(javadocTitle).close();
        }
        // open new breakpoint dialog (Ctrl+Shift+F8)
        String newBreakpointTitle = Bundle.getString("org.netbeans.modules.debugger.ui.actions.Bundle", "CTL_Breakpoint_Title");
        ActionNoBlock breakpointAction = new ActionNoBlock(null, null, new Action.Shortcut(KeyEvent.VK_F8, KeyEvent.SHIFT_MASK|KeyEvent.CTRL_MASK));
        try {
            breakpointAction.perform(MainWindowOperator.getDefault());
            new NbDialogOperator(newBreakpointTitle).close();
            // On some linux it may happen autorepeat is activated and it 
            // opens dialog multiple times. So, we need to close all modal dialogs.
            // See issue http://www.netbeans.org/issues/show_bug.cgi?id=56672.
            closeAllModal();
        } catch (TimeoutExpiredException e) {
            // need to be realiable test => repeat action once more to be sure it is problem in IDE
            // this time use events instead of Robot
            MainWindowOperator.getDefault().pushKey(KeyEvent.VK_F8, KeyEvent.SHIFT_MASK|KeyEvent.CTRL_MASK);
            new NbDialogOperator(newBreakpointTitle).close();
        }
    }
    
    /** Test Source Editor
     * - opens sample class in Editor (context menu Open on the node)
     * - type abbreviation 'sout' at line 27 and then 'Hello'
     * - verify it is written 'System.out.println("Hello");'
     * - select the text and call copy from editor's context menu
     * - insert dummy text at line 28 , select it and paste the text in the clipboard
     * - select second 'Hello' and delete it by context menu
     * - insert 'Good bye' instead
     * - select fourth line, cut it and paste it at line 3
     */
    public void testEditor() {
        // open sample file in Editor
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        Node sample1Node = new Node(sourcePackagesNode, SAMPLE1_PACKAGE_NAME);
        JavaNode sampleClass1Node = new JavaNode(sample1Node, SAMPLE1_FILE_NAME);
        sampleClass1Node.open();
        // find open file in editor
        EditorOperator eo = new EditorOperator(SAMPLE1_FILE_NAME);
        eo.insert("\n", 27, 1); // NOI18N
        // Need to disable verification because shortcut "sout" is replaced
        // by "System.out.println("");" and "sout" is not found in Editor
        eo.setCaretPositionToLine(27);
        eo.txtEditorPane().setVerification(false);
        eo.txtEditorPane().typeText("sout "); // NOI18N
        eo.txtEditorPane().setVerification(true);
        eo.insert("Hello"); // NOI18N
        //eo.insert("System.out.println(\"Hello\");\n", 28, 1); // NOI18N
        final String textToCopy = "System.out.println(\"Hello\");"; // NOI18N
        eo.select(textToCopy);
        int oldDispatchingModel = JemmyProperties.getCurrentDispatchingModel();
        // "Copy"
        CopyAction copyAction = new CopyAction();
        try {
            copyAction.perform(eo);
        } catch (TimeoutExpiredException e) {
            // if not succed try it second time in Robot mode
            JemmyProperties.setCurrentDispatchingModel(JemmyProperties.ROBOT_MODEL_MASK);
            copyAction.perform(eo);
        } finally {
            // set previous dispatching model
            JemmyProperties.setCurrentDispatchingModel(oldDispatchingModel);
        }
        // wait until clipboard contains text to copy
        try {
            new Waiter(new Waitable() {
                public Object actionProduced(Object obj) {
                    try {
                        String text = Toolkit.getDefaultToolkit().getSystemClipboard().
                                        getContents(null).getTransferData(DataFlavor.stringFlavor).toString();
                        return textToCopy.equals(text) ? Boolean.TRUE:null;
                    } catch (UnsupportedFlavorException e) {
                        // The following exception can be thrown when clipboard is empty.
                        // java.awt.datatransfer.UnsupportedFlavorException: Unicode String
                        // at org.openide.util.datatransfer.ExTransferable$Empty.getTransferData(ExTransferable.java:461)
                        // Ignore this exception.
                        return null;
                    } catch (IOException ioe) {
                        throw new JemmyException("Failed getting clipboard content.", ioe);
                    }
                }
                public String getDescription() {
                    return("Clipboard contains "+textToCopy); // NOI18N
                }
            }).waitAction(null);
        } catch (Exception ie) {
            throw new JemmyException("Interrupted.", ie);
        }
        eo.insert("int xxxx;\n", 28, 1); // NOI18N
        eo.select("int xxxx;"); // NOI18N
        PasteAction pasteAction = new PasteAction();
        try {
            pasteAction.perform(eo);
        } catch (TimeoutExpiredException e) {
            // if not succed try it second time in Robot mode
            JemmyProperties.setCurrentDispatchingModel(JemmyProperties.ROBOT_MODEL_MASK);
            pasteAction.perform(eo);
        } finally {
            // set previous dispatching model
            JemmyProperties.setCurrentDispatchingModel(oldDispatchingModel);
        }
        eo.select("Hello", 1); // NOI18N
        // "Delete"
        DeleteAction deleteAction = new DeleteAction();
        deleteAction.performShortcut(eo);
        // BEGIN - diagnose why it doesn't delete selected text
        try {
            // wait Hello is deleted
            eo.txtEditorPane().waitText("System.out.println(\"\");"); // NOI18N
        } catch (TimeoutExpiredException e) {
            // if not succed try it second time
            getLog("deleteIssue.txt").println("Timeout expired - trying again deleteAction.performShortcut(eo);");
            eo.requestFocus();
            deleteAction.performShortcut(eo);
            try {
                eo.txtEditorPane().waitText("System.out.println(\"\");"); // NOI18N
            } catch (TimeoutExpiredException e1) {
                // if not succed try it third time by popup
                getLog("deleteIssue.txt").println("Timeout expired - trying deleteAction.performMenu(eo);");
                deleteAction.performMenu(eo);
                eo.txtEditorPane().waitText("System.out.println(\"\");"); // NOI18N
            }
        }
        // END
        eo.insert("Good bye"); // NOI18N
        // test cut action
        eo.select(4);
        // "Cut"
        CutAction cutAction = new CutAction();
        try {
            cutAction.perform(eo);
        } catch (TimeoutExpiredException e) {
            // if not succed try it second time in Robot mode
            JemmyProperties.setCurrentDispatchingModel(JemmyProperties.ROBOT_MODEL_MASK);
            cutAction.perform(eo);
        } finally {
            // set previous dispatching model
            JemmyProperties.setCurrentDispatchingModel(oldDispatchingModel);
        }
        // need to wait a little until editor content is refreshed after cut action
        new EventTool().waitNoEvent(500);
        // select from column 1 to 2 at line 3 
        eo.select(3, 1, 2);
        try {
            pasteAction.perform(eo);
        } catch (TimeoutExpiredException e) {
            // if not succed try it second time in Robot mode
            JemmyProperties.setCurrentDispatchingModel(JemmyProperties.ROBOT_MODEL_MASK);
            pasteAction.perform(eo);
        } finally {
            // set previous dispatching model
            JemmyProperties.setCurrentDispatchingModel(oldDispatchingModel);
        }
    }
    
    /** Test build and run.
     * - select sample class node and call "Build|Compile "SampleClass1.java"" main menu item
     * - wait until compilation finishes (track status bar)
     * - select sample class node and call "Run|Run File|Run "SampleClass1.java"" main menu item
     * - wait until run finishes
     * - from context menu set sample project as main project
     * - call "Build|Build Main Project" main menu item
     * - wait until build finishes
     * - call "Run|Run Main Project" main menu item
     * - wait until run finishes
     */
    public void testBuildAndRun() {
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        Node sample1Node = new Node(sourcePackagesNode, SAMPLE1_PACKAGE_NAME);
        JavaNode sampleClass1Node = new JavaNode(sample1Node, SAMPLE1_FILE_NAME);
        // increase timeout to 60 seconds
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 60000);
        // start to track Main Window status bar
        MainWindowOperator.StatusTextTracer stt = MainWindowOperator.getDefault().getStatusTextTracer();
        stt.start();
        // call Build|Compile main menu item
        new CompileAction().perform(sampleClass1Node);
        /* We cannot get this bundle - ti is probably loaded by a different classLoader
        // "Finished building SampleProject (run)"
        String finishedLabel = Bundle.getString("org.apache.tools.ant.module.bridge.impl.Bundle", 
                                                "FMT_finished_target_status",
                                                new String[] {SAMPLE_PROJECT_NAME});
         */
        // wait message "Building SampleProject (compile-single)..."
        stt.waitText("compile-single", true); // NOI18N
        // wait message "Finished building SampleProject (compile-single)"
        stt.waitText("compile-single", true); // NOI18N
        
        // "Run" 
        String runItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.Bundle", "Menu/RunProject");
        // "Run File"
        String runOtherItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.Bundle", "Menu/RunProject/RunOther");
        // "Run File"
        String runFileItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", 
                                                     "LBL_RunSingleAction_Name",
                                                     new Object[] {new Integer(1), SAMPLE1_FILE_NAME});
        // call "Run|Run File|Run "SampleClass1.java""
        new Action(runItem+"|"+runOtherItem+"|"+runFileItem, null).perform(sampleClass1Node);
        // wait message "Building SampleProject (run-single)..."
        stt.waitText("run-single", true); // NOI18N
        // wait message "Finished building SampleProject (run-single)"
        stt.waitText("run-single", true); // NOI18N
        // check Hello and Good bye was printed out to the output window

        OutputTabOperator outputOper = new OutputTabOperator("run-single"); //NOI18N
        outputOper.waitText("Hello"); //NOI18N
        outputOper.waitText("Good bye"); //NOI18N
        
        // "Set as Main Project"
        String setAsMainProjectItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", "LBL_SetAsMainProjectAction_Name");
        new Action(null, setAsMainProjectItem).perform(new ProjectsTabOperator().getProjectRootNode(SAMPLE_PROJECT_NAME));
        // "Build"
        String buildItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Build");
        // "Build Main Project"
        String buildMainProjectItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", "LBL_BuildMainProjectAction_Name");
        // call "Build|Build Main Project" main menu item
        new Action(buildItem+"|"+buildMainProjectItem, null).perform();
        // wait message "Building SampleProject (jar)..."
        stt.waitText("jar", true); // NOI18N
        // wait message "Finished building SampleProject (jar)"
        stt.waitText("jar", true); // NOI18N
        
        // Run Main Project
        String runMainProjectItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", "LBL_RunMainProjectAction_Name");
        // call "Run|Run Main Project" main menu item
        new Action(runItem+"|"+runMainProjectItem, null).perform();
        // wait message "Building SampleProject (run)..."
        stt.waitText("run", true); // NOI18N
        // wait message "Finished building SampleProject (run)"
        stt.waitText("run", true); // NOI18N

        stt.stop();
    }
    
    /** Test JUnit support
     * - add methods to sample class
     * - from context menu on sample class node call "Tools|Create JUnit Tests" item
     * - confirm Create Tests dialog and wait until progress dialog disappears
     * - find generated test under "Test Packages"
     * - check whether test was open in editor and if includes test of public, 
     * protected, default but not private methods
     * - run single test from main menu "Run|Run File|Test SampleClass2.java"
     * - check status bar that test was executed
     * - run test project from main menu "Run|Test SampleProject"
     * - check status bar that test was executed
     * - from context menu on sample package call "Tools|Create JUnit Tests" item
     * - confirm Create Tests dialog and wait until progress dialog disappears
     * - find generated suite under "Test Packages"
     * - call main menu "Go To|Test" on sample package
     * - check if generated suite was opened and if contains generated test class
     * - close all documents in editor
     */
    public void testJUnit() throws InterruptedException {
        // open sample file in Editor
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        Node sample1Node = new Node(sourcePackagesNode, SAMPLE1_PACKAGE_NAME);
        JavaNode sampleClass2Node = new JavaNode(sample1Node, SAMPLE2_FILE_NAME);
        sampleClass2Node.open();
        // find open sample file in editor
        EditorOperator eo = new EditorOperator(SAMPLE2_FILE_NAME);
        // add methods declarations to sample file
        String publicMethod = "\n    public void publicMethod() {\n    }\n";  // NOI18N
        eo.insert(publicMethod, 29, 1);
        String privateMethod = "\n    private void privateMethod() {\n    }\n";  //NOI18N
        eo.insert(privateMethod, 32, 1);
        String protectedMethod = "\n    protected void protectedMethod() {\n    }\n";  //NOI18N
        eo.insert(protectedMethod, 35, 1);
        String defaultMethod = "\n    void defaultMethod() {\n    }\n";  //NOI18N
        eo.insert(defaultMethod, 38, 1);

        // "Tools"
        String toolsItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        // "Create JUnit Tests"
        String createTestsItem = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_Action_CreateTest"); // NOI18N
        ActionNoBlock createTestsAction = new ActionNoBlock(null, toolsItem+"|"+createTestsItem);
        createTestsAction.perform(sampleClass2Node);
        // "Create Tests"
        String createTestsTitle = Bundle.getString("org.netbeans.modules.junit.Bundle", "JUnitCfgOfCreate.Title");
        new NbDialogOperator(createTestsTitle).ok();
        // "Unit tests generation in progress ..."
        String progressTitle = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_generator_progress_title");
        // wait until progress dialog is closed
        new NbDialogOperator(progressTitle).waitClosed();
        // wait until test node is created
        // "Test Packages"
        String testPackagesLabel = Bundle.getString("org.netbeans.modules.java.j2seproject.Bundle", "NAME_test.src.dir");
        Node testPackagesNode = new Node(new ProjectsTabOperator().getProjectRootNode(SAMPLE_PROJECT_NAME), testPackagesLabel);
        // Test Packages|sample1|SampleClass1Test.java
        JavaNode testNode = new JavaNode(testPackagesNode, SAMPLE1_PACKAGE_NAME+"|"+SAMPLE2_CLASS_NAME+"Test.java"); // NOI18N

        // check default, protected and public method tests created and private is not created
        EditorOperator eoTest = new EditorOperator(SAMPLE2_CLASS_NAME+"Test.java");    // NOI18N
        // wait code is generated
        new Waiter(new Waitable() {
            public Object actionProduced(Object editorOper) {
                return ((EditorOperator)editorOper).contains("testDefaultMethod") ? Boolean.TRUE : null;
            }
            public String getDescription() {
                return("Created test should include test of default method."); // NOI18N
            }
        }).waitAction(eoTest);
        new Waiter(new Waitable() {
            public Object actionProduced(Object editorOper) {
                return ((EditorOperator)editorOper).contains("testProtectedMethod") ? Boolean.TRUE : null;
            }
            public String getDescription() {
                return("Created test should include test of protected method."); // NOI18N
            }
        }).waitAction(eoTest);
        new Waiter(new Waitable() {
            public Object actionProduced(Object editorOper) {
                return ((EditorOperator)editorOper).contains("testPublicMethod") ? Boolean.TRUE : null;
            }
            public String getDescription() {
                return("Created test should include test of public method."); // NOI18N
            }
        }).waitAction(eoTest);
        assertFalse("Created test should not include test of private method.", eoTest.contains("testPrivateMethod")); // NOI18N
        
        // run generated test
        
        // "Run" 
        String runItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.Bundle", "Menu/RunProject");
        // "Run File"
        String runOtherItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.Bundle", "Menu/RunProject/RunOther");
        // "Test File"
        String testFileItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", 
                                                     "LBL_TestSingleAction_Name",
                                                     new Object[] {new Integer(1), SAMPLE2_FILE_NAME});
        // "Test Project"
        String testProjectItem = Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", 
                                                     "LBL_TestProjectAction_Name",
                                                     new Object[] {new Integer(1), SAMPLE_PROJECT_NAME});
                                                     
        // increase timeout to 60 seconds
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 60000); // NOI18N
        // start to track Main Window status bar
        MainWindowOperator.StatusTextTracer stt = MainWindowOperator.getDefault().getStatusTextTracer();
        stt.start();
         // call "Run|Run File|Test "SampleClass2.java""
        new Action(runItem+"|"+runOtherItem+"|"+testFileItem, null).perform(sampleClass2Node);
         // wait message "Building SampleProject (test-single)..."
        stt.waitText("test-single", true); // NOI18N
        // wait message "Build of SampleProject (test-single) failed."
        stt.waitText("test-single", true); // NOI18N
         // call "Run|Test "SampleProject""
        new Action(runItem+"|"+testProjectItem, null).perform(sampleClass2Node);
         // wait message "Building SampleProject (test)..."
        stt.waitText("test", true); // NOI18N
        // wait message "Build of SampleProject (test) failed."
        stt.waitText("test", true); // NOI18N
        stt.stop();
        
        // test JUnit on folder
        createTestsAction.perform(sample1Node);
        new NbDialogOperator(createTestsTitle).ok();
        // wait until progress dialog is closed
        new NbDialogOperator(progressTitle).waitClosed();
        // wait until test node is created
        // Test Packages|sample1|Sample1Suite.java
        JavaNode suiteNode = new JavaNode(testPackagesNode, SAMPLE1_PACKAGE_NAME+"|Suite.java"); // NOI18N
        // go to  test suite
        // "Go To"
        String goToItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/GoTo"); // NOI18N
        // "Test"
        String testItem = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_Action_GoToTest");  // NOI18N
        // go to test ("Go To|Test") - main menu action
        Action gotoTestAction = new Action(goToItem+"|"+testItem, null);
        gotoTestAction.perform(sample1Node);
        // check suite is open in editor and it conteins generated test class
        assertTrue("Created suite should include test of public method.", 
                   new EditorOperator("Suite").contains(SAMPLE2_CLASS_NAME+"Test")); // NOI18N
        EditorOperator.closeDiscardAll();
    }

    /** Test Debugging
     * - find sample class in editor
     * - select text 'System.out.println("Hello");' and push Shift+F8 to toggle breakpoint
     * - select text 'System.out.println("Good bye");' and call 'Toggle Breakpoint" context menu item
     * - run debugger from main menu ("Run "SampleClass1.java" in  Debugger")
     * - wait until first breakpoint is reached and call Continue from main menu
     * - wait until second breakpoint is reached and check 'Hello' is printed to output
     * - finish debugger by main menu action (Finish Debugger Session)
     * - delete sample class
     */
    public void testDebugging() throws Throwable {
        // Status bar tracer
        MainWindowOperator.StatusTextTracer stt = MainWindowOperator.getDefault().getStatusTextTracer();
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        JavaNode sampleClass1Node = new JavaNode(sourcePackagesNode, SAMPLE1_PACKAGE_NAME+"|"+SAMPLE1_FILE_NAME);
        try {
            // find sample file in Editor
            EditorOperator eo = new EditorOperator(SAMPLE1_FILE_NAME);

            // if file not contains brpText from previous test cases, insert it
            String brpText = "System.out.println(\"Hello\");"; // NOI18N
            if(!eo.contains(brpText)) {
                eo.insert(brpText+"\n", 27, 1);
            }
            eo.select(brpText);
            
            ToggleBreakpointAction toggleBreakpointAction = new ToggleBreakpointAction();
            // toggle breakpoint via Shift+F8
            toggleBreakpointAction.performShortcut(eo);

            // wait breakpoint established
            new Waiter(new Waitable() {
                public Object actionProduced(Object editorOper) {
                    return ((EditorOperator)editorOper).getAnnotations(27).length == 1 ? Boolean.TRUE : null;
                }
                public String getDescription() {
                    return("Wait breakpoint established on line 27"); // NOI18N
                }
            }).waitAction(eo);
            
            // if file not contains second brpText from previous test cases, insert it
            brpText = "System.out.println(\"Good bye\");"; // NOI18N
            if(!eo.contains(brpText)) {
                eo.insert(brpText+"\n", 28, 1);
            }
            eo.select(brpText);
            // toggle breakpoint via pop-up menu
            // clickForPopup(0, 0) used in the past sometimes caused that menu
            // was opened outside editor area because editor roll up after 
            // text was selected
            toggleBreakpointAction.perform(eo.txtEditorPane());
            // wait second breakpoint established
            new Waiter(new Waitable() {
                public Object actionProduced(Object editorOper) {
                    return ((EditorOperator)editorOper).getAnnotations(28).length == 1 ? Boolean.TRUE : null;
                }
                public String getDescription() {
                    return("Wait breakpoint established on line 28"); // NOI18N
                }
            }).waitAction(eo);
            // start to track Main Window status bar
            stt.start();
            // start debugging
            new DebugAction().performMenu(sampleClass1Node);
            // check the first breakpoint reached
            // wait status text "Thread main stopped at SampleClass1.java:27"
            // increase timeout to 60 seconds
            MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 60000);
            String label27 = Bundle.getString("org.netbeans.modules.debugger.jpda.ui.Bundle",
                    "CTL_Thread_stopped",
                    new String[] {"main", SAMPLE1_FILE_NAME, null, "27"}); // NOI18N
            stt.waitText(label27);
            // continue debugging
            new ContinueAction().perform();
            // check the second breakpoint reached
            // wait status text "Thread main stopped at SampleClass1.java:28"
            String label28 = Bundle.getString("org.netbeans.modules.debugger.jpda.ui.Bundle",
                    "CTL_Thread_stopped",
                    new String[] {"main", SAMPLE1_FILE_NAME, null, "28"}); // NOI18N
            stt.waitText(label28);
            // check "Hello" was printed out in Output
            OutputTabOperator oto = new OutputTabOperator("debug-single"); // NOI18N
            // wait until text Hello is not written in to the Output
            oto.waitText("Hello"); // NOI18N
        } catch (Throwable th) {
            try {
                // capture screen before cleanup in finally clause is completed
                PNGEncoder.captureScreen(getWorkDir().getAbsolutePath()+File.separator+"screenBeforeCleanup.png");
            } catch (Exception e1) {
                // ignore it
            }
            throw th;
        } finally {
            // finish debugging
            new FinishDebuggerAction().perform();
            // check status line
            // "SampleProject (debug-single)"
            String outputTarget = Bundle.getString(
                    "org.apache.tools.ant.module.run.Bundle",
                    "TITLE_output_target",
                    new Object[] {SAMPLE_PROJECT_NAME, null, "debug-single"});  // NOI18N
            // "Finished building SampleProject (debug-single)"
            String finishedMessage = Bundle.getString(
                    "org.apache.tools.ant.module.run.Bundle",
                    "FMT_finished_target_status",
                    new Object[] {outputTarget});
            stt.waitText(finishedMessage);
            stt.stop();
            // delete sample class
            sampleClass1Node.delete();
            String confirmTitle = Bundle.getString("org.openide.explorer.Bundle", "MSG_ConfirmDeleteObjectTitle"); // NOI18N
            // "Confirm Object Deletion"
            new NbDialogOperator(confirmTitle).yes();
        }
    }

     /** Test Options  
      * - open Options window from main menu Tools|Options
      * - select General category
      * - set Web Browser to "Swing HTML Browser"
      * - pick HTTP Proxy
      * - set Proxy Host to webcache
      * - set Proxy Port to 8080
      * - click OK to confirm and close Options window
      */
    public void testOptions() {
        OptionsOperator optionsOper = OptionsOperator.invoke();
        optionsOper.selectGeneral();
        // "Web Browser:"
        String webBrowserLabel = Bundle.getStringTrimmed(
                "org.netbeans.modules.options.general.Bundle", "Web_Browser");
        JLabelOperator jloWebBrowser = new JLabelOperator(optionsOper, webBrowserLabel);
        // "Swing HTML Browser"
        String swingBrowserLabel = Bundle.getString("org.netbeans.core.ui.Bundle",
                                                    "Services/Browsers/SwingBrowser.ser");
        new JComboBoxOperator((JComboBox)jloWebBrowser.getLabelFor()).selectItem(swingBrowserLabel);
        // "HTTP Proxy"
        String hTTPProxyLabel = Bundle.getStringTrimmed(
                "org.netbeans.modules.options.general.Bundle", "CTL_Use_HTTP_Proxy");
        new JRadioButtonOperator(optionsOper, hTTPProxyLabel).push();
        // "Proxy Host:"
        String proxyHostLabel = Bundle.getStringTrimmed(
                "org.netbeans.modules.options.general.Bundle", "Proxy_Host");
        JLabelOperator jloHost = new JLabelOperator(optionsOper, proxyHostLabel);
        new JTextFieldOperator((JTextField)jloHost.getLabelFor()).typeText("webcache"); // NOI18N
        // "Proxy Port"
        String proxyPortLabel = Bundle.getStringTrimmed(
                "org.netbeans.modules.options.general.Bundle", "Proxy_Port");
        JLabelOperator jloPort = new JLabelOperator(optionsOper, proxyPortLabel);
        new JTextFieldOperator((JTextField)jloPort.getLabelFor()).setText("8080"); // NOI18N
        optionsOper.ok();
    }

     /** Test Options in Classic view. Options in Classic view should be gradually 
      * replaced by options in Modern view. When it happens this test case
      * can be removed.
      * - open Options window from main menu Tools|Options
      * - select IDE Configuration|System|System Settings node
      * - set Web Browser to "Swing HTML Browser"
      * - set Proxy Host to webcache
      * - set Proxy Port to 8080
      * - set Proxy Type to Use HTTP Proxy
      * - close Options window
      */
    public void testOptionsClassicView() {
        OptionsOperator optionsOper = OptionsOperator.invoke();
        optionsOper.switchToClassicView();
        // set exact comparator because in Japanese there is conflict with Filesystem settings
        optionsOper.treeTable().tree().setComparator(new Operator.DefaultStringComparator(true, true));
        // "IDE Configuration|System|System Settings"
        String systemSettings = Bundle.getString("org.netbeans.core.Bundle", "UI/Services/IDEConfiguration") + "|" +
                                Bundle.getString("org.netbeans.core.Bundle", "UI/Services/IDEConfiguration/System") + "|" +
                                Bundle.getString("org.netbeans.core.Bundle", "Services/org-netbeans-core-IDESettings.settings");
        optionsOper.selectOption(systemSettings);
        PropertySheetOperator pso = new PropertySheetOperator(optionsOper);
        // "Web Browser"
        String webBrowserLabel = Bundle.getString("org.netbeans.core.Bundle", "PROP_WWW_BROWSER");
        // "Swing HTML Browser"
        String swingBrowserLabel = Bundle.getString("org.netbeans.core.ui.Bundle",
                                                    "Services/Browsers/SwingBrowser.ser");
        new Property(pso, webBrowserLabel).setValue(swingBrowserLabel);
        // "Proxy Host"
        String proxyHostLabel = Bundle.getString("org.netbeans.core.Bundle", "PROP_PROXY_HOST");
        new Property(pso, proxyHostLabel).setValue("webcache"); // NOI18N
        // "Proxy Port"
        String proxyPortLabel = Bundle.getString("org.netbeans.core.Bundle", "PROP_PROXY_PORT");
        new Property(pso, proxyPortLabel).setValue("8080"); // NOI18N
        // "Type of proxy configuration"
        String proxyTypeLabel = Bundle.getString("org.netbeans.core.Bundle", "PROP_PROXY_TYPE");
        new Property(pso, proxyTypeLabel).setValue(1);
        optionsOper.close();
    }
    
    /** Test Update Center
     * - open Update Center Wizard from main menu Tools|Update Center
     * - set proxy and go next
     * - wait until connection dialog dismiss
     * - in modules tree select requested module
     * - click right arrow button and go next
     * - accept license dialog
     * - wait until download is finished and finish the wizard
     */
    public void testUpdateCenter() {
        // "Tools"
        String toolsItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        WizardOperator updateCenterWizardOper = null;
        long oldWaitStateTime = JemmyProperties.getCurrentTimeout("ComponentOperator.WaitStateTimeout");
        try {
            // "Update Center"
            String updateCenterItem = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.Bundle", "CTL_Update");
            new Action(toolsItem+"|"+updateCenterItem, null).perform();
            // "Update Center Wizard"
            String updateCenterTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Wizard");
            updateCenterWizardOper = new WizardOperator(updateCenterTitle);
            // disable Forte for Java Update Center if any
            JTableOperator oper = new JTableOperator(updateCenterWizardOper);
            // check each row
            for(int i=0;i<oper.getRowCount();i++) {
                // if Update Center matches "Forte" and it is enabled/checked then click to uncheck
                if(oper.getValueAt(i, 1).toString().indexOf("Forte")>-1 && ((Boolean)oper.getValueAt(i, 0)).booleanValue()) { // NOI18N
                    oper.clickOnCell(i, 0);
                }
                // if Update Center matches "Sun ONE Studio" and it is enabled/checked then click to uncheck
                if(oper.getValueAt(i, 1).toString().indexOf("Sun")>-1 && ((Boolean)oper.getValueAt(i, 0)).booleanValue()) { // NOI18N
                    oper.clickOnCell(i, 0);
                }
            }

            // set proxy
            // Proxy Configuration...
            String buttonProxyConfLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "BNT_Proxy"); // NOI18N
            new JButtonOperator(updateCenterWizardOper, buttonProxyConfLabel).pushNoBlock();
            // Proxy Configuration
            String proxyConfDialogTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_ProxyDialog_Title"); // NOI18N
            NbDialogOperator proxyDialog = new NbDialogOperator(proxyConfDialogTitle);
            String useProxyLabel = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.Bundle", "BTN_manualProxy");
            // select Use HTTP Proxy radio button
            new JRadioButtonOperator(proxyDialog, useProxyLabel).setSelected(true);
            // Proxy Host: text field
            new JTextFieldOperator(proxyDialog, 1).setText("webcache"); // NOI18N
            // Proxy Port: text field 
            new JTextFieldOperator(proxyDialog, 0).setText("8080"); // NOI18N
            proxyDialog.ok();
            
            // "Next >"
            updateCenterWizardOper.btNext().pushNoBlock();
            // wait connecting dialog appears
            // "Connecting"
            String connectingTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Connecting_Title");
            // wait at most 60 second until connecting dialog dismiss
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000);
            new NbDialogOperator(connectingTitle).waitClosed();
            // wait JTree generated on next page
            new EventTool().waitNoEvent(500);
            // select Web|Applet module
            JTreeOperator tree = new JTreeOperator(updateCenterWizardOper);
            // "Development Update Center
            String devUCLabel = Bundle.getString("org.netbeans.modules.updatecenters.resources.Bundle", "Services/AutoupdateType/autoupdate_xml_type.settings");
            new Node(tree, devUCLabel+"|Infrastructure|Convertor").select(); // NOI18N
            // "Add >"
            String addLabel = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.Bundle", "BTN_Add_2");
            // add to right panel (push "Add >" button)
            new JButtonOperator(updateCenterWizardOper, addLabel).push();
            // push "Next" button
            updateCenterWizardOper.btNext().pushNoBlock();
            // accept license agreement
            // "License Agreement"
            String licenceTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Licence_Title");
            // "Accept"
            String acceptLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Licence_Accept");
            new JButtonOperator(new NbDialogOperator(licenceTitle), acceptLabel).push();
            // wait 30 s until download is done
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitComponentTimeout", 30000); // NOI18N
            // "Done."
            String doneLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "DownloadProgressPanel.jLabel1.doneText");
            new JLabelOperator(updateCenterWizardOper, doneLabel);
            updateCenterWizardOper.next();
            // accept certificate if requested
            if(!updateCenterWizardOper.btFinish().isEnabled()) {
                // "View Certificate..."
                String viewCertificateLable = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.Bundle", "BTN_View");
                new JButtonOperator(updateCenterWizardOper, viewCertificateLable).pushNoBlock();
                // click on "Accept" button in dialog
                String acceptCertificateLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Certificate_Accept");
                // "Module Certificate"
                String certificateTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Certificate_Title");
                new JButtonOperator(new JDialogOperator(certificateTitle), acceptCertificateLabel).push();
            }
            // "Finish"
            updateCenterWizardOper.btFinish().push();
        } catch (JemmyException e) {
            // close possible error dialog
            // "Error"
            String errorTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Error");
            if(JDialogOperator.findJDialog(errorTitle, true, true) != null) {
                new NbDialogOperator(errorTitle).close();
            }
            // close Update center dialog
            if(updateCenterWizardOper != null) {
                updateCenterWizardOper.close();
            }
            throw e;
        } finally {
            // restore default timeout
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", oldWaitStateTime);
        }
    }
    
    /** Test CVS Lite
     * - from main menu invoke "CVS|Checkout"
     * - wait for Checkout dialog and close it
     * TODO - when better support for local repository implemented, we can add more tests
     */
    public void testCVSLite() {
        // "CVS"
        String cvsItem = Bundle.getStringTrimmed(
                "org.netbeans.modules.versioning.system.cvss.Bundle",
                "Menu/CVS");
        // "Checkout..."
        String checkoutItem = Bundle.getStringTrimmed(
                "org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.Bundle", 
                "CTL_MenuItem_Checkout_Label");
        new ActionNoBlock(cvsItem+"|"+checkoutItem, null).perform();

        String checkoutTitle = Bundle.getString(
                "org.netbeans.modules.versioning.system.cvss.ui.wizards.Bundle",
                "BK0007");
        NbDialogOperator checkoutOper = new NbDialogOperator(checkoutTitle);
        checkoutOper.close();
    }
    
    /** Test XML
     * It checks XML Entity Catalogs node is present in the Runtime tab,
     * creates an XML document from template, checks XML, validates XML,
     * generates DTD, checks DTD and generates DOM Tree Scanner.
     */
    public void testXML() {
        // check XML Entity Catalogs
        
        // "XML Entity Catalogs"
        String catalogsLabel = Bundle.getString("org.netbeans.modules.xml.catalog.Bundle", "TEXT_catalog_root");
        // "Depl.Desc.Catalog"
        String deplDescLabel = Bundle.getString("org.netbeans.modules.j2ee.ddloaders.web.Bundle", "LBL_DDCatalog");
        String publicID = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
        Node catalogNode = new Node(RuntimeTabOperator.invoke().getRootNode(), 
                                    catalogsLabel+"|"+
                                    deplDescLabel+"|"+
                                    publicID);
        // view and close it
        new ViewAction().perform(catalogNode);
        new EditorOperator(publicID).close();
        
        // create an XML file

        Node sample1Node = new Node(new SourcePackagesNode(SAMPLE_PROJECT_NAME), SAMPLE1_PACKAGE_NAME);
        // create xml package
        // select Source Packages to not create xml folder in Test Packages
        new SourcePackagesNode(SAMPLE_PROJECT_NAME).select();
        // "Java Classes"
        String javaClassesLabel = Bundle.getString("org.netbeans.modules.java.Bundle", "Templates/Classes");
        // "Java Package"
        String packageLabel = Bundle.getString("org.netbeans.modules.java.Bundle", "Templates/Classes/Package");
        NewFileWizardOperator.create(SAMPLE_PROJECT_NAME, javaClassesLabel, packageLabel, null, "xml"); // NOI18N
        Node xmlNode = new Node(new SourcePackagesNode(SAMPLE_PROJECT_NAME), "xml"); //NOI18N
        // "XML"
        String xmlCategory = Bundle.getString("org.netbeans.api.xml.resources.Bundle", "Templates/XML");
        // "XML Document"
        String xmlDocument = Bundle.getString("org.netbeans.modules.xml.core.resources.Bundle", "Templates/XML/XMLDocument.xml");
        NewFileWizardOperator.invoke(xmlNode, xmlCategory, xmlDocument);
        NewFileNameLocationStepOperator nameStepOper = new NewFileNameLocationStepOperator();
        nameStepOper.setObjectName("XMLDocument");  // NOI18N
        nameStepOper.next();
        nameStepOper.finish();
        // wait node is present
        Node xmlDocumentNode = new Node(xmlNode, "XMLDocument.xml"); // NOI18N
        // wait xml document is open in editor
        new EditorOperator("XMLDocument.xml").close();  // NOI18N

        // "Check XML"
        
        String checkXMLItem = Bundle.getStringTrimmed("org.netbeans.modules.xml.tools.actions.Bundle", "NAME_Check_XML");
        // invoke context action to check xml
        new Action(null, checkXMLItem).perform(xmlDocumentNode);
        // "XML check"
        String xmlCheckTitle = Bundle.getString("org.netbeans.modules.xml.core.actions.Bundle", "TITLE_XML_check_window");
        // find and close an output with the result of xml check
        new OutputTabOperator(xmlCheckTitle).close();
        
        // "Validate XML"
        
        String validateItem = Bundle.getStringTrimmed("org.netbeans.modules.xml.tools.actions.Bundle", "NAME_Validate_XML");
        // invoke context action to validate xml
        new Action(null, validateItem).perform(xmlDocumentNode);
        // find and close an output with the result of xml validation
        new OutputTabOperator(xmlCheckTitle).close();
        
        // "Generate DTD..."
        
        String generateDTDItem = Bundle.getStringTrimmed("org.netbeans.modules.xml.tools.generator.Bundle", "PROP_GenerateDTD");
        new ActionNoBlock(null, generateDTDItem).perform(xmlDocumentNode);
        // "Select File Name"
        String selectTitle = Bundle.getString("org.netbeans.modules.xml.tools.generator.Bundle", "PROP_fileNameTitle");
        NbDialogOperator selectDialog = new NbDialogOperator(selectTitle);
        // name has to be set because of issue http://www.netbeans.org/issues/show_bug.cgi?id=46049
        new JTextFieldOperator(selectDialog).setText("DTD");
        String oKLabel = Bundle.getString("org.netbeans.core.windows.services.Bundle", "OK_OPTION_CAPTION");
        new JButtonOperator(selectDialog, oKLabel).push();
        // wait DTD is open in editor
        new EditorOperator("DTD.dtd").close();  // NOI18N
        Node dtdNode = new Node(xmlNode, "DTD.dtd"); // NOI18N
        
        // "Check DTD"
        
        String checkDTDItem = Bundle.getStringTrimmed("org.netbeans.modules.xml.tools.actions.Bundle", "NAME_Validate_DTD");
        new Action(null, checkDTDItem).perform(dtdNode);
        // find and close an output with the result of dtd check
        new OutputTabOperator(xmlCheckTitle).close();
        
        // "Generate DOM Tree Scanner"
        
        String generateScannerItem = Bundle.getStringTrimmed("org.netbeans.modules.xml.tools.generator.Bundle", "PROP_GenerateDOMScanner");
        new ActionNoBlock(null, generateScannerItem).perform(dtdNode);
        selectDialog = new NbDialogOperator(selectTitle);
        new JButtonOperator(selectDialog, oKLabel).push();
        // wait Scanner is open in editor
        new EditorOperator("DTDScanner.java").close();  // NOI18N
        Node scannerNode = new Node(xmlNode, "DTDScanner.java"); // NOI18N
        
        // clean up
        
        // delete xml folder and its contents
        DeleteAction deleteAction = new DeleteAction();
        deleteAction.perform(xmlNode);
        // "Confirm Object Deletion"
        String confirmTitle = Bundle.getString("org.openide.explorer.Bundle", "MSG_ConfirmDeleteObjectTitle"); // NOI18N
        new NbDialogOperator(confirmTitle).yes();
        xmlNode.waitNotPresent();
    }

    /** Test Web Application
     * - create new Web Application project
     * - wait until project is in Projects view
     * - wait classpath scanning finished
     * - set Swing HTML Browser as default
     * - set application to be deployed at Bundled Tomcat server (in project properties)
     * - set a random port for Tomcat server
     * - insert error statement into index.jsp, compile it and verify it failed
     * - correct error in index.jsp, compile it and verify it succeded
     * - run project from context menu on project's root node
     * - wait until Deployment Progress Monitor is closed
     * - wait until JSP Page is open in browser and close it
     */
    public void testWebApplication() throws Exception {
        // create new web application project
        
        NewProjectWizardOperator npwo = NewProjectWizardOperator.invoke();
        // "Web"
        String webLabel = Bundle.getString("org.netbeans.modules.web.core.Bundle", "Templates/JSP_Servlet");
        npwo.selectCategory(webLabel);
        // "Web Application"
        String webApplicationLabel = org.netbeans.jellytools.Bundle.getString("org.netbeans.modules.web.project.ui.wizards.Bundle", "Templates/Project/Web/emptyWeb.xml");
        npwo.selectProject(webApplicationLabel);
        npwo.next();
        NewProjectNameLocationStepOperator npnlso = new NewProjectNameLocationStepOperator();
        npnlso.txtProjectName().setText(SAMPLE_WEB_PROJECT_NAME);
        npnlso.txtProjectLocation().setText(System.getProperty("netbeans.user")); // NOI18N
        npnlso.finish();
        // wait project appear in projects view
        // wait 30 second
        JemmyProperties.setCurrentTimeout("JTreeOperator.WaitNextNodeTimeout", 30000); // NOI18N
        new ProjectsTabOperator().getProjectRootNode(SAMPLE_WEB_PROJECT_NAME);
        // wait index.jsp is opened in editor
        EditorOperator editor = new EditorOperator("index.jsp"); // NOI18N
        // wait classpath scanning finished
        ProjectSupport.waitScanFinished();
        
        // Set Swing HTML Browser as default browser
        
        OptionsOperator optionsOper = OptionsOperator.invoke();
        optionsOper.selectGeneral();
        // "Web Browser:"
        String webBrowserLabel = Bundle.getStringTrimmed("org.netbeans.modules.options.general.Bundle", "Web_Browser");
        JLabelOperator jloWebBrowser = new JLabelOperator(optionsOper, webBrowserLabel);
        // "Swing HTML Browser"
        String swingBrowserLabel = Bundle.getString("org.netbeans.core.ui.Bundle", "Services/Browsers/SwingBrowser.ser");
        new JComboBoxOperator((JComboBox)jloWebBrowser.getLabelFor()).selectItem(swingBrowserLabel);
        optionsOper.ok();
        
        // Set application to be deployed at Bundled Tomcat server
        
        // open project properties
        new ProjectsTabOperator().getProjectRootNode(SAMPLE_WEB_PROJECT_NAME).properties();
        // "Project Properties"
        String projectPropertiesTitle = Bundle.getStringTrimmed("org.netbeans.modules.web.project.ui.customizer.Bundle", "LBL_Customizer_Title");
        NbDialogOperator propertiesDialogOper = new NbDialogOperator(projectPropertiesTitle);
        // "Run"
        String runLabel = Bundle.getString("org.netbeans.modules.web.project.ui.customizer.Bundle", "LBL_Config_Run");
        // select "Run" category
        new Node(new JTreeOperator(propertiesDialogOper), runLabel).select();
        // set Bundled Tomcat as deployment server
        new JComboBoxOperator(propertiesDialogOper).selectItem("Bundled Tomcat"); // NOI18N
        // confirm dialog
        propertiesDialogOper.ok();
        
        // Set a random port for Tomcat server

        // "Tools"
        String toolsItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        // "Server Manager"
        String serverManagerItem = Bundle.getStringTrimmed(
                "org.netbeans.modules.j2ee.deployment.impl.ui.actions.Bundle", 
                "CTL_ServerManager");
        new ActionNoBlock(toolsItem+"|"+serverManagerItem, null).perform();
        // "Server Manager"
        String serverManagerTitle = Bundle.getString(
                "org.netbeans.modules.j2ee.deployment.devmodules.api.Bundle", 
                "TXT_ServerManager");
        NbDialogOperator serverManagerOper = new NbDialogOperator(serverManagerTitle);
        String j2eeLabel = Bundle.getString(
                "org.netbeans.modules.j2ee.deployment.impl.ui.Bundle", 
                "LBL_J2eeServersNode");
        new Node(new JTreeOperator(serverManagerOper), j2eeLabel+"|"+"Bundled Tomcat").select(); // NOI18N
        // set server port
        JSpinnerOperator serverPortOper = new JSpinnerOperator(serverManagerOper, 0);
        // satisfy focus on spinner which causes changes are reflected
        serverPortOper.getNumberSpinner().scrollToValue((Number)serverPortOper.getNextValue());
        serverPortOper.setValue(new Integer(getPort()));
        // set shutdown port
        JSpinnerOperator shutdownPortOper = new JSpinnerOperator(serverManagerOper, 1);
        // satisfy focus on spinner which causes changes are reflected
        shutdownPortOper.getNumberSpinner().scrollToValue((Number)shutdownPortOper.getNextValue());
        shutdownPortOper.setValue(new Integer(getPort()));
        serverManagerOper.close();
        
        // Compile JSP
        
        Node projectRootNode = new ProjectsTabOperator().getProjectRootNode(SAMPLE_WEB_PROJECT_NAME);
        // "Web Pages"
        String webPagesLabel = Bundle.getString(
                "org.netbeans.modules.web.project.ui.Bundle", "LBL_Node_DocBase");
        Node jspNode = new Node(projectRootNode, webPagesLabel+"|index.jsp"); // NOI18N
        // insert error statement
        editor.insert("<%= nonExistentVar %>", 23, 1);
        CompileAction compileAction = new CompileAction();
        compileAction.perform(jspNode);
        // "SampleWebProject (compile-single-jsp)"
        String outputTarget = Bundle.getString(
                "org.apache.tools.ant.module.run.Bundle", "TITLE_output_target", 
                new Object[] {SAMPLE_WEB_PROJECT_NAME, null, "compile-single-jsp"});  // NOI18N
        // "Build of SampleWebProject (compile-single-jsp) failed."
        String failedMessage = Bundle.getString(
                "org.apache.tools.ant.module.run.Bundle", "FMT_target_failed_status",
                new Object[] {outputTarget});
        // "Finished building SampleWebProject (compile-single-jsp)"
        String finishedMessage = Bundle.getString(
                "org.apache.tools.ant.module.run.Bundle", "FMT_finished_target_status", 
                new Object[] {outputTarget});
        MainWindowOperator.getDefault().waitStatusText(failedMessage);
        // check error message is printed
        new OutputTabOperator("compile-single-jsp").waitText("nonExistentVar"); // NOI18N
        // correct JSP file
        editor.replace("<%= nonExistentVar %>", "");
        // compile again
        compileAction.perform(jspNode);
        MainWindowOperator.getDefault().waitStatusText(finishedMessage);

        // Run project
        
        // "Run Project"
        String runProjectItem = Bundle.getString("org.netbeans.modules.web.project.ui.Bundle", "LBL_RunAction_Name");
        new Action(null, runProjectItem).perform(new ProjectsTabOperator().getProjectRootNode(SAMPLE_WEB_PROJECT_NAME));
        // wait until page is displayed in internal browser
        long oldTimeout = JemmyProperties.getCurrentTimeout("ComponentOperator.WaitComponentTimeout");
        try {
            // increase time to wait to 120 second (it fails on Linux)
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitComponentTimeout", 120000);
            new TopComponentOperator("JSP Page").close(); // NOI18N
        } finally {
            // restore default timeout
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitComponentTimeout", oldTimeout);
            // log messages from output
            getLog("TomcatMessages0").print(new OutputTabOperator("Bundled Tomcat", 0).getText()); // NOI18N
            getLog("TomcatMessages1").print(new OutputTabOperator("Bundled Tomcat", 1).getText()); // NOI18N
            getLog("RunOutput").print(new OutputTabOperator(SAMPLE_WEB_PROJECT_NAME).getText()); // NOI18N
            // stop Tomcat server
            try {
                // "Bundled Tomcat (x.y.z)"
                String tomcatLabel = Bundle.getStringTrimmed("org.netbeans.modules.tomcat5.Bundle", "LBL_BundledTomcat");
                J2eeServerNode serverNode = new J2eeServerNode(tomcatLabel);
                serverNode.stop();
            } catch (JemmyException e) {
                // ignore it
            }
        }
    }
    
    /** Test Window System 
     * - open Favorites top component from main menu Window|Favorites
     * - attach Favorites as last tab to output mode
     * - attach Favorites to top of Projects tab
     * - attach Favorites to right of output mode
     * - attach Favorites as last tab to explorer mode (next to Projects)
     * - close Favorites
     * - open sample1|SampleClass2.java file
     * - maximize opened editor by menu item "Maximize Window" on its tab
     * - restore editor by menu item "Restore Window" on its tab
     * - close all open editors
     */
    public void testWindowSystem() {
        final ProjectsTabOperator projectsOper = ProjectsTabOperator.invoke();
        final FavoritesOperator favoritesOper = FavoritesOperator.invoke();
        
        // test attaching
        favoritesOper.attachTo(new OutputOperator(), AttachWindowAction.AS_LAST_TAB);
        favoritesOper.attachTo(projectsOper, AttachWindowAction.TOP);
        favoritesOper.attachTo(new OutputOperator(), AttachWindowAction.RIGHT);
        favoritesOper.attachTo(projectsOper, AttachWindowAction.AS_LAST_TAB);
        // wait until TopComponent is in new location and is showing
        final TopComponent projectsTc = (TopComponent)projectsOper.getSource();
        final TopComponent favoritesTc = (TopComponent)favoritesOper.getSource();
        try {
            new Waiter(new Waitable() {
                public Object actionProduced(Object tc) {
                    // run in dispatch thread
                    Mode mode1 = (Mode)projectsOper.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("findMode") {    // NOI18N
                        public Object launch() {
                            return WindowManager.getDefault().findMode(projectsTc);
                        }
                    });
                    Mode mode2 = (Mode)favoritesOper.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("findMode") {    // NOI18N
                        public Object launch() {
                            return WindowManager.getDefault().findMode(favoritesTc);
                        }
                    });
                    return (mode1==mode2 && favoritesTc.isShowing()) ? Boolean.TRUE : null;
                }
                public String getDescription() {
                    return("Favorites TopComponent is next to Projects TopComponent."); // NOI18N
                }
            }).waitAction(null);
        } catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", e); // NOI18N
        }
        favoritesOper.close();

        // test maximize/restore
        // open sample file in Editor
        SourcePackagesNode sourcePackagesNode = new SourcePackagesNode(SAMPLE_PROJECT_NAME);
        Node sample1Node = new Node(sourcePackagesNode, SAMPLE1_PACKAGE_NAME);
        JavaNode sampleClass2Node = new JavaNode(sample1Node, SAMPLE2_FILE_NAME);
        sampleClass2Node.open();
        // find open file in editor
        EditorOperator eo = new EditorOperator(SAMPLE2_FILE_NAME);
        eo.maximize();
        eo.restore();
        eo.closeDiscardAll();
    }

    /** Test Separate Windows Mode
     * - switch to separate windows mode
     * - check whether Projects and Output are in separate window
     * - switch back to the default compact windows mode
     * Note: It happens editor area enlarge itself to cover all main window area.
     * That's why it is recommended to put this test to the end of the suite.
     */
    public void testSeparateWindowsMode() {
        try {
            MainWindowOperator.getDefault().setSeparateMode();
            assertFalse("Projects has to be in separate frame.", new ProjectsTabOperator().getWindow() == MainWindowOperator.getDefault().getSource());
            assertFalse("Output has to be in separate frame.", new OutputOperator().getWindow() == MainWindowOperator.getDefault().getSource());
        } finally {
            // set back to the compact mode
            MainWindowOperator.getDefault().setCompactMode();
        }
    }

    /** Test Module installation.
     * - open Module Manager window from main menu Tools|Module Manager
     * - find Image module
     * - disable Image module
     * - wait until it is turned off
     * - enable module again
     * - wait until it is enabled
     * - close Module Manager window
     */
    public void testModuleInstallation() {
        // "Tools"
        String toolsItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        // "Module Manager"
        String moduleManagerLabel = Bundle.getString("org.netbeans.modules.autoupdate.catalog.Bundle", "LBL_ModuleCatalogName");
        new Action(toolsItem+"|"+moduleManagerLabel, null).perform();
        NbDialogOperator moduleManagerOper = new NbDialogOperator(moduleManagerLabel);
        // Data Files|Image
        String imageModulePath = 
            Bundle.getString("org.netbeans.modules.image.Bundle", "OpenIDE-Module-Display-Category") + "|" +  // Data Files
            Bundle.getString("org.netbeans.modules.image.Bundle", "OpenIDE-Module-Name"); // Image
        TreeTableOperator treeTableOper = new TreeTableOperator(moduleManagerOper);
        TreePath path = treeTableOper.tree().findPath(imageModulePath, "|");
        if(!treeTableOper.tree().isPathSelected(path)) {
            treeTableOper.tree().selectPath(path);
        }
        int rowNumber = treeTableOper.tree().getRowForPath(path);
        treeTableOper.scrollToCell(rowNumber, 0);
        new EventTool().waitNoEvent(500);
        // click check box to disable module
        treeTableOper.clickOnCell(rowNumber, 1);
        // check Status line
        // "Turning off modules...done."
        String turningOffLabel = Bundle.getString("org.netbeans.core.startup.Bundle", "MSG_finish_disable_modules");
        // increase timeout to 120 seconds
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 120000);
        MainWindowOperator.getDefault().waitStatusText(turningOffLabel);
        new EventTool().waitNoEvent(1000);
        // click check box to enable module
        treeTableOper.clickOnCell(rowNumber, 1);
        // check Status line
        // "Turning on modules...done."
        String turningOnLabel = Bundle.getString("org.netbeans.core.startup.Bundle", "MSG_finish_enable_modules");
        // increase timeout to 120 seconds
        MainWindowOperator.getDefault().getTimeouts().setTimeout("Waiter.WaitingTime", 120000);
        MainWindowOperator.getDefault().waitStatusText(turningOnLabel);
        moduleManagerOper.close();
    }

    /** Closes help window if any. It should not stay open between test cases.
     *  Otherwise it can break next tests.
     */
    private static void closeHelpWindow() {
        Window helpWindow = WindowOperator.findWindow(new ComponentChooser() {
            public boolean checkComponent(Component comp) {
                WindowOperator winOper = new WindowOperator((Window)comp);
                winOper.setOutput(TestOut.getNullOutput());
                return  null != winOper.findSubComponent(new ComponentChooser() {
                    public boolean checkComponent(Component comp) {
                        return comp.getClass().getName().startsWith("javax.help.JHelp"); //NOI18N
                    }
                    public String getDescription() {
                        return("any javax.help");  //NOI18N
                    }
                });
            }
            public String getDescription() {
                return "containing any javax.help.JHelp component";  //NOI18N
            }
        });
        if(helpWindow != null) {
            new WindowOperator(helpWindow).close();
        }
    }
    
    /** Returns unique free port number within range of dynamic or private ports
     * (see http://www.iana.org/assignments/port-numbers)
     */
    private static int getPort() throws Exception {
        int port = 0;
        boolean notfree = true;
        while(notfree) {
            port = 49152+new Random().nextInt(16383);
            // test whether port is already used
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(port);
                socket.close();
                // found a free port
                notfree = false;
            } catch (IOException ioe) {
                // BindException: Address already in use thrown
            }
        }
        return port;
    }
}
