/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.httpserver;

import java.awt.Image;
import java.beans.*;
import java.util.ResourceBundle;

import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/** BeanInfo for http - custom editor for hosts property
*
* @author Ales Novak, Petr Jiricka
*/
public class HttpServerSettingsBeanInfo extends SimpleBeanInfo {

    /** @return the ExternalCompilerSettings' icon */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
	    return Utilities.loadImage("org/netbeans/modules/httpserver/httpServerSettings.gif"); // NOI18N
        } else {
    	    return Utilities.loadImage ("org/netbeans/modules/httpserver/httpServerSettings32.gif"); // NOI18N
        }
    }

    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
            PropertyDescriptor[] desc = new PropertyDescriptor[] {
                       new PropertyDescriptor("port", HttpServerSettings.class), // 0 // NOI18N
                       new PropertyDescriptor("running", HttpServerSettings.class, "isRunning", null), // 1 // NOI18N
                       new PropertyDescriptor("hostProperty", HttpServerSettings.class), // 2 // NOI18N
                       new PropertyDescriptor("showGrantAccess", HttpServerSettings.class, "isShowGrantAccessDialog", "setShowGrantAccessDialog") // 3 // NOI18N
                   };
    	    ResourceBundle bundle = NbBundle.getBundle(HttpServerSettingsBeanInfo.class);
            desc[0].setDisplayName(bundle.getString("PROP_Port"));
            desc[0].setShortDescription(bundle.getString("HINT_Port"));
            desc[1].setDisplayName(bundle.getString("PROP_Running"));
            desc[1].setShortDescription(bundle.getString("HINT_Running"));
            desc[2].setDisplayName(bundle.getString("PROP_HostProperty"));
            desc[2].setShortDescription(bundle.getString("HINT_HostProperty"));
            desc[2].setPropertyEditorClass (HostPropertyEditor.class);
            desc[3].setDisplayName(bundle.getString("PROP_showGrantAccess"));
            desc[3].setShortDescription(bundle.getString("HINT_showGrantAccess"));
            return desc;
        } catch (IntrospectionException ex) {
            ErrorManager.getDefault().notify(ex);
            return null;
        }
    }

    public BeanDescriptor getBeanDescriptor(){
        BeanDescriptor bd = new BeanDescriptor(HttpServerSettings.class);
        bd.setShortDescription(NbBundle.getMessage(HttpServerSettingsBeanInfo.class, "CTL_HTTP_sett_HINT"));
        return bd;
    }


}
