/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javascript.editor.syntax;

import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.junit.NbTestCase;

/** Basic JavaScript syntax parser tests.
 *
 * @author  Marek Fukala
 */
public class JSSyntaxTest extends NbTestCase {
    
    //it's static since the junit creates a new instance of this class for each test method
    private static JSSyntax syntax = new JSSyntax();
    
    public JSSyntaxTest() {
        super("javascriptsyntaxtest");
    }
    
    //test methods -----------
    
    public void testSimpleCode() {
        loadContentToSyntax("var i = 1234;");
        char[] buffer = syntax.getBuffer();
        //acquire all token relevant data
        TokenID tokenID = syntax.nextToken();
        assertNotNull(tokenID);
    
        TokenContextPath tcp = syntax.getTokenContextPath();        
        assertNotNull(tcp);
        assertEquals(JSTokenContext.contextPath, tcp);
        assertEquals(JSTokenContext.VAR, tokenID);
        
        String tokenImage = new String(buffer, syntax.getTokenOffset(), syntax.getTokenLength());
        assertNotNull(tokenImage);
    }
    
    
    //helper methods -----------
    private void loadContentToSyntax(String content) {
        //load syntax - scan the whole buffer - the buffer is last one
        char[] buffer = content.toCharArray();
        syntax.load(null, buffer, 0, buffer.length, true, -1);
    }
    
}
