/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.html.editor.folding;

import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.netbeans.editor.ext.html.SyntaxElement;

/**
 * Utility class. Contains mostly debug messages suport.
 *
 * @author Marek Fukala
 */
public class HTMLFoldUtils {
    
    /** Prints folds recursivelly into standard output*/
    public static void printFolds(FoldOperation fo) {
        FoldHierarchy fh = fo.getHierarchy();
        fh.lock();
        try {
            Fold rootFold = fh.getRootFold();
            printChildren(rootFold, 0);
        } finally {
            fh.unlock();
        }
    }
    
    private static void printChildren(Fold f, int level) {
        int foldCount = f.getFoldCount();
        //indent
        for( int i = 0; i < level; i ++) System.out.print(" "); // NOI18N
        //print this fold info
        System.out.println(f.getDescription() + " [" + f.getStartOffset() + " - " + f.getEndOffset() + "]"); // NOI18N
        //print children
        for (int i = 0; i < foldCount; i++) {
            Fold childFold = f.getFold(i);
            printChildren(childFold, level + 4);
        }
        
    }
  
    public static String getContextName(int typeId) {
        switch(typeId) {
            case SyntaxElement.TYPE_TAG:
                return "tag"; // NOI18N
            case SyntaxElement.TYPE_COMMENT:
                return "comment"; // NOI18N
            default:
                return "?"; // NOI18N
        }
    } 
    
}
