/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext.html;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;


/**
 *
 * @author  Petr Pisl
 */
public class HTMLDrawLayerFactory {
    
    /** Creates a new instance of HTMLDrawLayerFactory */
    public HTMLDrawLayerFactory() {
    }
    
    
    public static class TagParenWatcher implements DocumentListener {
	
	private void check(DocumentEvent evt) {
	    //System.out.println("check"); // NOI18N
            if (evt.getDocument() instanceof BaseDocument) {
		BaseDocument doc = (BaseDocument)evt.getDocument();
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
		
		int offset = evt.getOffset();
		doc.repaintBlock(offset-3, offset);
	    }
	}
	
	public void changedUpdate(javax.swing.event.DocumentEvent evt) {
	    
	}
	
	public void insertUpdate(javax.swing.event.DocumentEvent evt) {
	    check(evt);
	}
	
	public void removeUpdate(javax.swing.event.DocumentEvent evt) {
	    check(evt);
	}
	
    }
}
