/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.form.layoutdesign.support;

import java.util.*;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;

/**
 * Utilities for swing layout support.
 *
 * @author Jan Stola
 */
public class SwingLayoutUtils {
    /** The default resizability of the component is not known. */
    public static final int STATUS_UNKNOWN = -1;
    /** The component is not resizable by default. */
    public static final int STATUS_NON_RESIZABLE = 0;
    /** The component is resizable by default. */
    public static final int STATUS_RESIZABLE = 1;
    
    /**
     * Contains class names of non-resizable components e.g.
     * components that are non-resizable unless one (or more) of
     * minimumSize, preferredSize or maximumSize properties is changed.
     */
    private static Set nonResizableComponents = new HashSet();
    static {
        nonResizableComponents.addAll(
            Arrays.asList(new String[] {
                "javax.swing.JLabel", // NOI18N
                "javax.swing.JButton", // NOI18N
                "javax.swing.JToggleButton", // NOI18N
                "javax.swing.JCheckBox", // NOI18N
                "javax.swing.JRadioButton", // NOI18N
                "javax.swing.JList", // NOI18N
            })
        );
    }

    /**
     * Contains class names of resizable components e.g.
     * components that are resizable unless one (or more) of
     * minimumSize, preferredSize or maximumSize properties is changed.
     */
    private static Set resizableComponents = new HashSet();
    static {
        resizableComponents.addAll(
            Arrays.asList(new String[] {
                "javax.swing.JComboBox", // NOI18N
                "javax.swing.JTextField", // NOI18N
                "javax.swing.JTextArea", // NOI18N
                "javax.swing.JTabbedPane", // NOI18N
                "javax.swing.JScrollPane", // NOI18N
                "javax.swing.JSplitPane", // NOI18N
                "javax.swing.JFormattedTextField", // NOI18N
                "javax.swing.JPasswordField", // NOI18N
                "javax.swing.JSpinner", // NOI18N
                "javax.swing.JSeparator", // NOI18N
                "javax.swing.JTextPane", // NOI18N
                "javax.swing.JEditorPane", // NOI18N
                "javax.swing.JInternalFrame", // NOI18N
                "javax.swing.JLayeredPane", // NOI18N
                "javax.swing.JDesktopPane" // NOI18N
            })
        );
    }

    /**
     * Determines whether the given class represents component
     * that is resizable (by default) or not.
     *
     * @param componentClass <code>Class</code> object corresponding
     * to component we are interested in.
     * @return <code>STATUS_RESIZABLE</code>, <code>STATUS_NON_RESIZABLE</code>
     * or <code>STATUS_UNKNOWN</code>.
     */
    public static int getResizableStatus(Class componentClass) {
        String className = componentClass.getName();
        if (resizableComponents.contains(className)) return STATUS_RESIZABLE;
        if (nonResizableComponents.contains(className)) return STATUS_NON_RESIZABLE;
        return STATUS_UNKNOWN;
    }

    public static Map createLinkSizeGroups(LayoutComponent layoutComponent, int dimension) {
        
        Map linkSizeGroup = new HashMap();
        
        if (layoutComponent.isLayoutContainer()) {
            Iterator i = layoutComponent.getSubcomponents();
            
            while (i.hasNext()) {
                LayoutComponent lc = (LayoutComponent)i.next();
                if (lc != null) {
                    if (lc.isLinkSized(dimension)) {
                        String cid = lc.getId();
                        Integer id = new Integer(lc.getLinkSizeId(dimension));
                        List l = (List)linkSizeGroup.get(id);
                        if (l == null) {
                            l = new ArrayList();
                            l.add(cid);
                            linkSizeGroup.put(id, l);
                        } else {
                            l.add(cid);
                        }
                    }
                }
            }
        }
        return linkSizeGroup;
    }
    
}
