/*
 * TestGenerateDialog.java
 *
 * Created on December 3, 2002, 4:53 PM
 */

package org.netbeans.test.editor.app.gui;

import javax.swing.JFileChooser;

/**
 *
 * @author  eh103527
 */
public class TestGenerateDialog extends javax.swing.JDialog {
    
    String path, packageName;
    boolean state;
    
    /** Creates new form TestGenerateDialog */
    public TestGenerateDialog(java.awt.Frame parent, String dir) {
        super(parent, true);
        initComponents();
        pack();
        setPath(dir);
        String pack=getClass().getPackage().getName();
        pack=pack.substring(0,pack.lastIndexOf('.'));
        setPackageName(pack);
        setLocation(parent.getX()+(parent.getWidth()-getWidth())/2,parent.getY()+(parent.getHeight()-getHeight())/2);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        packageF = new javax.swing.JTextField();
        jPanel7 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jPanel6 = new javax.swing.JPanel();
        pathF = new javax.swing.JTextField();
        pathB = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        generateB = new javax.swing.JButton();
        cancelB = new javax.swing.JButton();

        setTitle("Generate Test Settings");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel4.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel1.setText("Package: ");
        jPanel4.add(jLabel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel4, gridBagConstraints);

        jPanel5.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        packageF.setColumns(31);
        jPanel5.add(packageF);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel5, gridBagConstraints);

        jPanel7.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel2.setText("Path: ");
        jPanel7.add(jLabel2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel7, gridBagConstraints);

        pathF.setColumns(25);
        jPanel6.add(pathF);

        pathB.setText("Path");
        pathB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pathBActionPerformed(evt);
            }
        });

        jPanel6.add(pathB);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel6, gridBagConstraints);

        jPanel1.add(jPanel3);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 10, 5));

        generateB.setText("Generate");
        generateB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                generateBActionPerformed(evt);
            }
        });

        jPanel2.add(generateB);

        cancelB.setText("Cancel");
        cancelB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBActionPerformed(evt);
            }
        });

        jPanel2.add(cancelB);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents
    
    private void pathBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pathBActionPerformed
        // Add your handling code here:
        setModal(false);
        JFileChooser dlg=new JFileChooser(path);
        dlg.setDialogTitle("Select Folder");
        dlg.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        if (dlg.showDialog(getParent(),"Select") == JFileChooser.APPROVE_OPTION) {
            setPath(dlg.getSelectedFile().getAbsolutePath());
        }
        setModal(true);
    }//GEN-LAST:event_pathBActionPerformed
    
    private void generateBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generateBActionPerformed
        // Add your handling code here:
        state=true;
        path=pathF.getText();
        packageName=packageF.getText();
        close();
    }//GEN-LAST:event_generateBActionPerformed
    
    private void cancelBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBActionPerformed
        // Add your handling code here:
        state=false;
        close();
    }//GEN-LAST:event_cancelBActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        close();
    }//GEN-LAST:event_closeDialog
    
    private void close() {
        setVisible(false);
        dispose();
    }
    /** Getter for property path.
     * @return Value of property path.
     *
     */
    public java.lang.String getPath() {
        return path;
    }
    
    /** Setter for property path.
     * @param path New value of property path.
     *
     */
    public void setPath(java.lang.String path) {
        this.path = path;
        pathF.setText(path);
    }
    
    /** Getter for property packageName.
     * @return Value of property packageName.
     *
     */
    public java.lang.String getPackageName() {
        return packageName;
    }
    
    /** Setter for property packageName.
     * @param packageName New value of property packageName.
     *
     */
    public void setPackageName(java.lang.String packageName) {
        this.packageName = packageName;
        packageF.setText(packageName);
    }
    
    public boolean getState() {
        return state;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton pathB;
    private javax.swing.JButton cancelB;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField pathF;
    private javax.swing.JTextField packageF;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton generateB;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel6;
    // End of variables declaration//GEN-END:variables
    
}
