/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.lib.editor.hyperlink.HyperlinkProviderManager;
import org.openide.util.Lookup;

/**
 * Finds hyperlink providers in the System FileSystem. The HyperlinkProvider(s) should
 * be registered as ".instance" objects under <code>Editors/&lt;mime-type&gt;/HyperlinkProviders</code>
 * directory.
 *
 * @author Jan Lahoda
 */
public final class LayerHyperlinkProviderManager extends HyperlinkProviderManager {
    
    private Lookup lookup;
    
    /**
     * Creates a new instance of LayerHyperlinkProviderManager
     */
    public LayerHyperlinkProviderManager() {
    }

    public List/*<HyperlinkProvider>*/ getHyperlinkProviders(String mimeType) {
        return new ArrayList(MimeLookup.getMimeLookup(mimeType).lookup(new Lookup.Template(HyperlinkProvider.class)).allInstances());
    }
    
}
