/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.actions.SystemAction;

/**
 *
 * @author Martin Roskanin
 */
public class PopupActions implements InstanceProvider{
    
    List ordered;
    
    private static final boolean debugSort
        = Boolean.getBoolean("netbeans.debug.editor.utils.sort.debug"); // NOI18N
    
    /** used from LayerFolderObjectsProvider */
    private static List hidden = new ArrayList();
    

    public PopupActions(){
    }
    
    public PopupActions(List ordered){
        this.ordered = ordered;
    }

    public List getPopupActions(String subFolderName){
        List folderList = new ArrayList();
        for (int i = 0; i<ordered.size(); i++){
            DataObject dob = (DataObject) ordered.get(i);
            if (dob instanceof DataFolder){
                DataFolder folder = (DataFolder) dob;
                if (subFolderName.equals(folder.getName())){
                    folderList.add(folder);
                }
            }
        }
        
        return getPopupActionsImpl(mergeObjects(folderList));
    }
    
    public List getPopupActions(){
        List retList = getPopupActionsImpl(ordered);
        List cacheList = new ArrayList();
        for (int i = 0; i< retList.size(); i++){
            Object item = retList.get(i);
            if (item instanceof DataFolder){
                DataFolder folder = (DataFolder)item;
                String name = folder.getName();
                boolean found = false;
                for (int j=0; j<cacheList.size(); j++){
                    Object item2 = cacheList.get(j);
                    if (item2 instanceof DataFolder){
                        DataFolder folder2 = (DataFolder)item2;
                        String name2 =folder2.getName(); 
                        if (name.equals(name2)){
                            found = true;
                            if (folder2.getPrimaryFile().
                                    getAttribute("SystemFileSystem.localizingBundle") == null){ //NOI18N
                                String attr = (String) folder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle"); //NOI18N
                                if (attr != null){
                                    try{
                                        folder2.getPrimaryFile().setAttribute("SystemFileSystem.localizingBundle", //NOI18N
                                                attr);
                                    } catch (IOException ioe){
                                        ioe.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
                if (!found){
                    cacheList.add(item);
                }
            } else {
                cacheList.add(item);
            }
        }
        return cacheList;
    }
    
    private List getPopupActionsImpl(List items){
        List retList = new ArrayList();
        for (int i = 0; i<items.size(); i++){
            DataObject dob = (DataObject) items.get(i);
            InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
            if (ic!=null){
                try{
                    if (String.class.isAssignableFrom(ic.instanceClass()) ||
                        Action.class.isAssignableFrom(ic.instanceClass()) ||
                        SystemAction.class.isAssignableFrom(ic.instanceClass()) ||
                        JSeparator.class.isAssignableFrom(ic.instanceClass()) ||
                        DataFolder.class.isAssignableFrom(ic.instanceClass())){
                        
                        Object instance = ic.instanceCreate();
                        retList.add(instance);
                    }
                }catch(IOException ioe){
                    ioe.printStackTrace();
                }catch(ClassNotFoundException cnfe){
                    cnfe.printStackTrace();
                }
            } else if (dob instanceof DataFolder) {
                retList.add(dob);
            } else {
                retList.add(dob.getName());
            }
        }
        return retList;
    }

    public Object createInstance(List ordered) {
        return new PopupActions(ordered);
    }
    
    
    private static List mergeObjects(List dataFoldersList) {
        Map name2dob = new HashMap();
        Map edges = new HashMap();
        hidden.clear();
        for (int i =0; i<dataFoldersList.size(); i++){
            DataFolder folder = (DataFolder) dataFoldersList.get(i);
            addDataObjects(name2dob, folder.getChildren());
        }

        for (int i =0; i<dataFoldersList.size(); i++){
            DataFolder folder = (DataFolder) dataFoldersList.get(i);
            addEdges(edges, name2dob, folder);
        }
        
        try {
            return org.openide.util.Utilities.topologicalSort(name2dob.values(), edges);
        } catch (TopologicalSortException ex) {
            ErrorManager.getDefault().notify(ex);
            return ex.partialSort();
        }
    }
    
    /** Append array of dataobjects to the existing list of dataobjects. Also
     * append the names of added dataobjects so that the both dobs and names
     * list are in the same order.
     * @param dobs valid existing list of dataobjects
     * @param names valid existing list of names of the dataobjects from dobs list.
     * @param addDobs dataobjects to be added.
     */
    private static void addDataObjects(Map name2dob, DataObject[] addDobs) {
        int addDobsLength = addDobs.length;
        for (int i = 0; i < addDobsLength; i++) {
            DataObject dob = addDobs[i];
            String dobName = dob.getPrimaryFile().getNameExt();
            if ((dobName != null && dobName.endsWith("_hidden"))) { //NOI18N
                String originalName = dobName.substring(0, dobName.indexOf("_hidden"));//NOI18N
                hidden.add(originalName);
            } else if (isHidden(dob.getPrimaryFile())) {
                hidden.add(dobName);
            } else {
                if (!hidden.contains(dobName)){
                    name2dob.put(dobName, dob);
                }
            }
        }
    }
    
    private static boolean isHidden(FileObject fo){
        for (Enumeration e = fo.getAttributes();
            e.hasMoreElements();
        ) {
            String name = (String)e.nextElement();
            if ("hidden".equals(name)) { //NOI18N
                Object value = fo.getAttribute(name);
                if ((value instanceof Boolean) && ((Boolean) value).booleanValue()){
                    return true;
                }
            }
        }
        return false;
    }

    /** Append the pairs - first dob name then second dob name to the list
     * of sort pairs for the dataobjects from the given folder.
     */
    private static void addEdges(Map edges, Map name2dob, DataFolder folder) {
        FileObject primaryFile = folder.getPrimaryFile();
        for (Enumeration e = primaryFile.getAttributes();
            e.hasMoreElements();
        ) {
            String name = (String)e.nextElement();
            int slashIndex = name.indexOf("/"); // NOI18N
            if (slashIndex != -1) { //NOI18N
                Object value = primaryFile.getAttribute(name);
                if ((value instanceof Boolean) && ((Boolean) value).booleanValue()){
                    String name1 = name.substring(0, slashIndex);
                    String name2 = name.substring(slashIndex + 1);
                    if (debugSort) {
                        System.err.println("SORT-PAIR: [" + name1 + ", " + name2 + "]"); // NOI18N
                    }
                    
                    DataObject dob = (DataObject)name2dob.get(name1);
                    DataObject target = (DataObject)name2dob.get(name2);
                    if (dob != null && target != null) {
                        Collection targetVertices = (Collection)edges.get(dob);
                        if (targetVertices == null) { // none target vertices yet
                            // Use just singleton list to save space
                            targetVertices = Collections.singletonList(target);
                            edges.put(dob, targetVertices);

                        } else if (targetVertices.size() == 1) { // singleton list
                            targetVertices = new HashSet(targetVertices);
                            targetVertices.add(target);
                            edges.put(dob, targetVertices);

                        } else {
                            targetVertices.add(target);
                        }
                    }
                }
            }
        }
    }
    
}
