/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.XMLStorage.Attribs;
import org.openide.ErrorManager;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


/**
 * This class contains support static methods for loading / saving and 
 * translating coloring (fontsColors.xml) files. It calls XMLStorage utilities.
 *
 * @author Jan Jancura
 */
public class KeyMapsStorage {

    
    // load ....................................................................
    
    /**
     * Object [Map (List (KeyStroke) > MultiKeyBinding),
     *         Set (List (KeyStroke))]
     *  [modified, removed]
     */
    public static Object[] loadKeyMaps (
        String[] mimeTypes, 
        String profile,
        String fileName
    ) {
        // 1) load colorings
        if (profile.equals ("NetBeans")) profile = null;
        FileObject defaultFo = Utils.getFileObject (
            mimeTypes, profile, fileName
        );
        if (defaultFo == null) 
            return new Object[] {
                Collections.EMPTY_MAP,
                Collections.EMPTY_SET
            };
        return loadKeyMaps (defaultFo);
    }    
    
    /**
     * Object [Map (List (KeyStroke) > MultiKeyBinding),
     *         Set (List (KeyStroke))]
     *  [modified, removed]
     */
    public static Object[] loadKeyMaps (
        FileObject fo
    ) {
        return (Object[]) XMLStorage.load (fo, new KeyMapsReader ());
    }    

    private static class KeyMapsReader extends XMLStorage.Handler {
        private Map keyMap = new HashMap ();
        private Set removedShortcuts = new HashSet ();
        
        Object getResult () {
            return new Object[] {keyMap, removedShortcuts};
        }
        
        public void startElement (
            String uri, 
            String localName,
            String name, 
            Attributes attributes
        ) throws SAXException {
            try {
                if (name.equals ("bindings")) {
                } else
                if (name.equals ("bind")) {
                    String actionName = attributes.getValue ("actionName");
                    String key = attributes.getValue ("key");
                    KeyStroke[] shortcut = Utils.stringToKeyStrokes (key);
                    String remove = attributes.getValue ("remove");
                    if (remove != null && remove.equals ("true")) {
                        removedShortcuts.add (Arrays.asList (shortcut));
                        return;
                    }
                    MultiKeyBinding mkb = new MultiKeyBinding (shortcut, actionName);
                    keyMap.put (Arrays.asList (shortcut), mkb);
                }
            } catch (Exception ex) {
                ErrorManager.getDefault ().notify (ex);
            }
        }
        
        public InputSource resolveEntity (String pubid, String sysid) {
            return new InputSource (
		new java.io.ByteArrayInputStream (new byte [0])
	    );
        }
    }    

    
    // save colorings ..........................................................
    
    public static void deleteProfile (
        String[] mimeTypes, 
        String profile,
        String fileName
    ) {
        Utils.deleteFileObject (mimeTypes, profile, fileName);
    }
    
    public static void saveKeyMaps (
        String[] mimeTypes, 
        String profile,
        String fileName,
        Collection keyMap,  // Collection (MultiKeyBinding) modified shortcuts
        Collection removed  // Collection (List (KeyStroke))) removed shortcuts
    ) {
        if (profile.equals ("NetBeans")) profile = null;
        FileObject fo = Utils.createFileObject (mimeTypes, profile, fileName);
        saveKeyMaps (fo, keyMap, removed);
    }
    
    private static void saveKeyMaps (
        FileObject fo, 
        Collection /*<MultiKeyBinding>*/ keyMap, 
        Collection /*<List>*/ removed
    ) {
        final StringBuffer sb = XMLStorage.generateHeader ();
        XMLStorage.generateFolderStart (sb, "bindings", null, "");
        Iterator it = keyMap.iterator ();
        while (it.hasNext ()) {
            MultiKeyBinding mkb = (MultiKeyBinding) it.next ();
            Attribs attributes = new Attribs (true);
            attributes.add (
		"actionName", 
		mkb.getActionName ()
	    );
            attributes.add (
		"key", 
		Utils.keyStrokesToString (mkb.getKeyStrokeList ())
	    );
            XMLStorage.generateLeaf (sb, "bind", attributes, "    ");
        }
        it = removed.iterator ();
        while (it.hasNext ()) {
            String shortcut = Utils.keyStrokesToString ((List) it.next ());
            Attribs attributes = new Attribs (true);
            attributes.add (
		"key", 
		shortcut
	    );
            attributes.add (
		"remove", 
		"true"
	    );
            XMLStorage.generateLeaf (sb, "bind", attributes, "    ");
        }
        XMLStorage.generateFolderEnd (sb, "bindings", "");
        XMLStorage.save (fo, new String (sb));
    }
}
