/*
 * MacrosModelTest.java
 * JUnit based test
 *
 * Created on 27. jen 2005, 12:28
 */

package org.netbeans.modules.options.macros;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.netbeans.modules.options.editor.IDEInitializer;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.openide.util.lookup.Lookups;


/**
 *
 * @author Administrator
 */
public class MacrosModelTest extends TestCase {
    
    static {
        IDEInitializer.setup (
            new String[] {
                "org/netbeans/modules/options/editor/mf-layer.xml",
                "org/netbeans/modules/java/editor/resources/layer.xml",
                "org/netbeans/modules/defaults/mf-layer.xml",
                "org/netbeans/core/ui/resources/layer.xml"
            },
            new Object[] {}
        );
    }    
    
    public MacrosModelTest (String testName) {
        super (testName);
    }
    
    public void testAddMacro () {
        IDEInitializer.cleanWorkDir ();
        
        // 1) init model
        MacrosModel model = new MacrosModel (
            Lookups.singleton (new KeymapViewModel ())
        );
        Iterator it = model.getMacroNames ().iterator ();
        Map macros = readMacros (model);
        Vector original = clone (model.getShortcutsTableModel ().getDataVector ());
        
        // 2) do some changes
        model.addMacro ("testName", "testValue");
        model.setShortcut (getIndex (model, "testName"), "Alt+Shift+H");
        model.addMacro ("testName2", "testValue2");
        model.setShortcut (getIndex (model, "testName2"), "Alt+Shift+R");
        
        // 3) test changes
        assertFalse (original.equals (model.getShortcutsTableModel ().getDataVector ()));
        assertEquals (original.size () + 2, model.getShortcutsTableModel ().getDataVector ().size ());
        assertEquals (original.size () + 2, model.getMacroNames ().size ());
        assertEquals ("testValue", model.getMacroText ("testName"));
        assertEquals ("testValue2", model.getMacroText ("testName2"));
        assertEquals ("Alt+Shift+H", getShortcut (model, "testName"));
        assertEquals ("Alt+Shift+R", getShortcut (model, "testName2"));
        
        model.applyChanges ();
        
        // 3) test changes
        assertFalse (original.equals (model.getShortcutsTableModel ().getDataVector ()));
        assertEquals (original.size () + 2, model.getShortcutsTableModel ().getDataVector ().size ());
        assertEquals (original.size () + 2, model.getMacroNames ().size ());
        assertEquals ("testValue", model.getMacroText ("testName"));
        assertEquals ("testValue2", model.getMacroText ("testName2"));
        assertEquals ("Alt+Shift+H", getShortcut (model, "testName"));
        assertEquals ("Alt+Shift+R", getShortcut (model, "testName2"));
        
        model = new MacrosModel (
            Lookups.singleton (new KeymapViewModel ())
        );
        
        // 3) test changes
        assertFalse (original.equals (model.getShortcutsTableModel ().getDataVector ()));
        assertEquals (original.size () + 2, model.getShortcutsTableModel ().getDataVector ().size ());
        assertEquals (original.size () + 2, model.getMacroNames ().size ());
        assertEquals ("testValue", model.getMacroText ("testName"));
        assertEquals ("testValue2", model.getMacroText ("testName2"));
        assertEquals ("Alt+Shift+H", getShortcut (model, "testName"));
        assertEquals ("Alt+Shift+R", getShortcut (model, "testName2"));
    }
    
    private String getShortcut (MacrosModel model, String macroName) {
        Iterator it = model.getShortcutsTableModel ().getDataVector ().
            iterator ();
        while (it.hasNext ()) {
            Vector line = (Vector) it.next ();
            if (line.get (0).equals (macroName))
                return (String) line.get (1);
        }
        return null;
    }
    
    private Vector clone (Vector v) {
        Iterator it = v.iterator ();
        Vector result = new Vector ();
        while (it.hasNext ()) {
            Vector line = (Vector) it.next ();
           result.add (line.clone ());
        }
        return result;
    }
    
    private int getIndex (MacrosModel model, String macroName) {
        Vector data = model.getShortcutsTableModel ().getDataVector ();
        int i, k = data.size ();
        for (i = 0; i < k; i++) {
            Vector line = (Vector) data.get (i);
            if (macroName.equals (line.get (0))) return i;
        }
        return -1;
    }
    
    private Map readMacros (MacrosModel model) {
        Iterator it = model.getMacroNames ().iterator ();
        Map macros = new HashMap ();
        while (it.hasNext ()) {
            String macroName = (String) it.next ();
            macros.put (
                macroName,
                model.getMacroText (macroName)
            );
        }
        return macros;
    }
}
