/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.general;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.EditorKit;
import org.netbeans.core.IDESettings;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;


class GeneralOptionsModel {
    
    
    int getProxyType () {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        if (ideSettings.getProxyType () == IDESettings.DIRECT_CONNECTION)
            return 0;
        if (ideSettings.getProxyType () == IDESettings.AUTO_DETECT_PROXY)
            return 1;
        return 2;
    }
    
    void setProxyType (int proxyType) {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        switch (proxyType) {
            case 0:
                ideSettings.setProxyType (IDESettings.DIRECT_CONNECTION);
                break;
            case 1:
                ideSettings.setProxyType (IDESettings.AUTO_DETECT_PROXY);
                break;
            default:
                ideSettings.setProxyType (IDESettings.MANUAL_SET_PROXY);
        }
    }
    
    String getProxyHost () {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        return ideSettings.getUserProxyHost ();
    }
    
    void setProxyHost (String proxyHost) {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        ideSettings.setUserProxyHost (proxyHost);
    }
    
    int getProxyPort () {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        try {
            return Integer.parseInt (ideSettings.getUserProxyPort ());
        } catch (NumberFormatException ex) {
            return -1;
        }
    }
    
    void setProxyPort (int proxyPort) {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        ideSettings.setUserProxyPort ("" + proxyPort);
    }
    
    String getUserNonProxy () {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        return code2view (ideSettings.getUserNonProxyHosts ());
    }
    
    void setUserNonProxy (String nonProxy) {
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        ideSettings.setUserNonProxyHosts (view2code (nonProxy));
    }
    
    boolean getAutoUpdateAskBeforeCheck () {
        Settings settings = (Settings) Settings.findObject 
            (Settings.class, true);
        return settings.isAskBefore ();
    }
    
    void setAutoUpdateAskBeforeCheck (boolean ask) {
        Settings settings = (Settings) Settings.findObject 
            (Settings.class, true);
        settings.setAskBefore (ask);
    }
    
    int getAutoUpdatePeriod () {
        Settings settings = (Settings) Settings.findObject 
            (Settings.class, true);
        return settings.getPeriod ();
    }
    
    void setAutoUpdatePeriod (int period) {
        Settings settings = (Settings) Settings.findObject 
            (Settings.class, true);
        settings.setPeriod (period);
    }
    
    boolean isTextAntialiasing () {
        return AllOptionsFolder.getDefault ().isTextAntialiasing ();
    }
    
    void setTextAntialiasing (boolean textAntialiasing) {
        AllOptionsFolder.getDefault ().setTextAntialiasing (textAntialiasing);
    }
    
    Map getCodeFoldingProperties () {
       return (Map) getEditorOption 
            ("getCodeFoldingProps", "text/x-java");
    }
    
    void setCodeFoldingProperties (Map properties) {
        setEditorOption 
            ("setCodeFoldingProps", Map.class, properties);
    }
    
    boolean getAutoPopupCompletion () {
        Boolean b = (Boolean) getEditorOption 
            ("getCompletionAutoPopup", "text/x-java");
        if (b == null) return true;
        return b.booleanValue ();
    }
    
    void setAutoPopupCompletion (boolean auto) {
        setEditorOption ("setCompletionAutoPopup", Boolean.TYPE, new Boolean (auto));
    }
    
    boolean getAutoPopupJavaDoc () {
        Boolean b = (Boolean) getEditorOption 
            ("getJavaDocAutoPopup", "text/x-java");
        if (b == null) return true;
        return b.booleanValue ();
    }
    
    void setAutoPopupJavaDoc (boolean auto) {
        setEditorOption ("setJavaDocAutoPopup", Boolean.TYPE, new Boolean (auto));
    }

    
    // private helper methods ..................................................
    
    private static Object getEditorOption (String methodName, String mimeType) {
        //S ystem.out.println("\n getEditorOption " + methodName + " : " + mimeType);
        BaseOptions options = getOptions (mimeType);
        try {
            Method m = options.getClass ().getMethod 
                (methodName, new Class[] {});
            return m.invoke (options, new Object [] {});
        } catch (NoSuchMethodException ex) {
            ex.printStackTrace ();
        } catch (IllegalAccessException ex) {
            ex.printStackTrace ();
        } catch (InvocationTargetException ex) {
            ex.printStackTrace ();
        }
        return null;
    }
    
    private static void setEditorOption (String methodName, Class paramType, Object value) {
        //S ystem.out.println("\n setEditorOption " + methodName + " : " + value);
        Iterator it = AllOptionsFolder.getDefault ().getInstalledOptions ().
            iterator ();
        while (it.hasNext ()) {
            Class optionsClass = (Class) it.next ();
            BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
                (optionsClass, true);
            try {
                //S ystem.out.println (baseOptions.getClass ());
                Method m = baseOptions.getClass ().getMethod 
                    (methodName, new Class[] {paramType});
                //S ystem.out.println("  " + m);
                m.invoke (baseOptions, new Object[] {value});
                //S ystem.out.println("invoked! " + baseOptions);
            } catch (NoSuchMethodException ex) {
            } catch (InvocationTargetException ex) {
                ex.printStackTrace ();
            } catch (IllegalAccessException ex) {
            }
        }
    }
    
    private static BaseOptions getOptions (String mimeType) {
        Iterator it = AllOptionsFolder.getDefault ().getInstalledOptions ().
            iterator ();
        while (it.hasNext ()) {
            Class optionsClass = (Class) it.next ();
            BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
                (optionsClass, true);
            BaseKit kit = BaseKit.getKit (baseOptions.getKitClass ());
            if (kit.getContentType ().equals (mimeType))
                return baseOptions;
        }
        return null;
    }
    
    private static String code2view (String code) {
        return code == null ? code : code.replaceAll ("\\|", ",\\ "); // NOI18N
    }
    
    private static String view2code (String view) {
        return view == null ? view : view.replaceAll (",\\ ", "\\|"); // NOI18N
    }
}


