/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.editor;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.netbeans.modules.options.codetemplates.CodeTemplatesPanelController;
import org.netbeans.modules.options.generaleditor.GeneralEditorPanelController;
import org.netbeans.modules.options.indentation.IndentationPanelController;
import org.netbeans.modules.options.macros.MacrosPanelController;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

  
/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public final class EditorPanelController extends OptionsPanelController {

    private GeneralEditorPanelController general = new GeneralEditorPanelController ();
    private IndentationPanelController indentation = new IndentationPanelController ();
    private CodeTemplatesPanelController codeTemplates = new CodeTemplatesPanelController ();
    private MacrosPanelController macros = new MacrosPanelController ();
    
    
    public void update () {
        general.update ();
        indentation.update ();
        codeTemplates.update ();
        macros.update ();
    }
    
    public void applyChanges () {
        general.applyChanges ();
        indentation.applyChanges ();
        codeTemplates.applyChanges ();
        macros.applyChanges ();
    }
    
    public void cancel () {
        general.cancel ();
        indentation.cancel ();
        codeTemplates.cancel ();
        macros.cancel ();
    }
    
    public boolean isValid () {
        if (!general.isValid ()) return false;
        if (!indentation.isValid ()) return false;
        if (!codeTemplates.isValid ()) return false;
        if (!macros.isValid ()) return false;
        return true;
    }
    
    public boolean isChanged () {
        if (general.isChanged ()) return true;
        if (indentation.isChanged ()) return true;
        if (codeTemplates.isChanged ()) return true;
        if (macros.isChanged ()) return true;
        return false;
    }
    
    public HelpCtx getHelpCtx () {
        return new HelpCtx ("netbeans.optionsDialog.editor");
    }
    
    public JComponent getComponent (Lookup masterLookup) {
        return new EditorPanel (
            general.getComponent (masterLookup),
            indentation.getComponent (masterLookup),
            codeTemplates.getComponent (masterLookup),
            macros.getComponent (masterLookup)
        );
    }

    public void addPropertyChangeListener (PropertyChangeListener l) {
        general.addPropertyChangeListener (l);
        indentation.addPropertyChangeListener (l);
        codeTemplates.addPropertyChangeListener (l);
        macros.addPropertyChangeListener (l);
    }

    public void removePropertyChangeListener (PropertyChangeListener l) {
        general.removePropertyChangeListener (l);
        indentation.removePropertyChangeListener (l);
        codeTemplates.removePropertyChangeListener (l);
        macros.removePropertyChangeListener (l);
    }
}
