/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.options.indentation.IndentationPanel;
import org.netbeans.modules.options.macros.MacrosPanel;
import org.netbeans.spi.options.OptionsCategory;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;


/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public final class EditorPanel extends JPanel {

    private JTabbedPane             tabbedPane = new JTabbedPane ();
    
    
    public EditorPanel (
        JComponent generalEditorPanel,
        JComponent indentationPanel,
        JComponent codeTemplatesPanel,
        JComponent macrosPanel
    ) {
        generalEditorPanel.setBorder (new EmptyBorder (8, 8, 8, 8));
        indentationPanel.setBorder (new EmptyBorder (8, 8, 8, 8));
        codeTemplatesPanel.setBorder (new EmptyBorder (8, 8, 8, 8));
        macrosPanel.setBorder (new EmptyBorder (8, 8, 8, 8));
        tabbedPane.addTab (loc ("General_Tab"), generalEditorPanel);
        tabbedPane.addTab (loc ("Indentation_Tab"), indentationPanel);
        tabbedPane.addTab (loc ("Code_Templates_Tab"), codeTemplatesPanel);
        tabbedPane.addTab (loc ("Macro_Tab"), macrosPanel);
        tabbedPane.setMnemonicAt (0, loc ("General_Tab_Mnemonic").charAt (0));
        tabbedPane.setMnemonicAt (1, loc ("Indentation_Tab_Mnemonic").charAt (0));
        tabbedPane.setMnemonicAt (2, loc ("Code_Templates_Tab_Mnemonic").charAt (0));
        tabbedPane.setMnemonicAt (3, loc ("Macro_Tab_Mnemonic").charAt (0));
        
        FormLayout layout = new FormLayout (
            "f:p:g", // cols
            "f:p:g"  // rows
        );      
        
        PanelBuilder builder = new PanelBuilder (layout, this);
        CellConstraints cc = new CellConstraints ();
        builder.add (tabbedPane, cc.xy (1, 1));
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (EditorPanel.class, key);
    }
}


