/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.codetemplates;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;

import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.NotifyDescriptor.InputLine;

import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public final class CodeTemplatesPanel extends JPanel implements 
ActionListener, ListSelectionListener {

    
    private JComboBox           cbLanguage = new JComboBox ();
    private JTable              tTemplates = new JTable ();
    private JScrollPane         spTable = new JScrollPane (tTemplates);
    private JEditorPane         epTemplates = new JEditorPane ();
    private JButton             bNew = new JButton ();
    private JButton             bRemove = new JButton ();
    private JComboBox           cbExpander = new JComboBox ();
    
    private CodeTemplatesModel  model;
    
    
    public CodeTemplatesPanel () {
        
        // 1) init components
        bRemove.setEnabled (false);
        loc (bNew, "New");
        loc (bRemove, "Remove");
        JLabel lExpander = new JLabel ();
        loc (lExpander, "Expander_Key");
        JPanel pExpander = new JPanel (new FlowLayout ());
        pExpander.add (lExpander);
        pExpander.add (cbExpander);
        cbExpander.addItem (loc ("SPACE"));
        cbExpander.addItem (loc ("S-SPACE"));
        cbExpander.addItem (loc ("TAB"));
        cbExpander.addItem (loc ("ENTER"));
        tTemplates.getTableHeader ().setReorderingAllowed (false);
        tTemplates.getSelectionModel ().setSelectionMode 
            (ListSelectionModel.SINGLE_SELECTION);
        Font f = tTemplates.getFont (); 
        spTable.setPreferredSize (new Dimension (10, 10));
        JLabel lbTemplates = new JLabel ();
        loc (lbTemplates, "Template_List");
        lbTemplates.setLabelFor (tTemplates);
        JLabel lbExpandedText = new JLabel ();
        loc (lbExpandedText, "Expanded_Text");
        lbExpandedText.setLabelFor (epTemplates);
        epTemplates.setPreferredSize (new Dimension (10, 10));
        
        // 2) init layout
        FormLayout layout = new FormLayout (
            "p, 5dlu, 100dlu, 100dlu:g, 5dlu, p", // cols
            "p, 5dlu, p, 1dlu, p, 3dlu, p, f:20dlu:g, 5dlu, p, 1dlu, f:20dlu:g, 5dlu, p"// rows
        );
        layout.setRowGroups (new int[][] {{3, 7}});
        
        PanelBuilder builder = new PanelBuilder (layout, this);
        CellConstraints cc = new CellConstraints ();
        CellConstraints lc = new CellConstraints ();
        builder.addLabel (loc ("CTL_Language"),            lc.xy (1, 1),
                          cbLanguage,                      cc.xy (3, 1));
        builder.add (lbTemplates,                          lc.xy (1, 3));
        builder.add (spTable,                           cc.xywh (1, 5, 4, 4));
        builder.add (     bNew,                            cc.xy (6, 5));
        builder.add (     bRemove,                         cc.xy (6, 7));
        builder.add (lbExpandedText,                       lc.xyw (1, 10, 4));
        builder.add (new JScrollPane (epTemplates),        cc.xyw (1, 12, 4));
        builder.add (pExpander,                            cc.xyw (1, 14, 4, "l, c"));
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (CodeTemplatesPanel.class, key);
    }
    
    private static void loc (Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext ().setAccessibleName (loc ("AN_" + key));
            c.getAccessibleContext ().setAccessibleDescription (loc ("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText (
                (AbstractButton) c, 
                loc ("CTL_" + key)
            );
        } else {
            Mnemonics.setLocalizedText (
                (JLabel) c, 
                loc ("CTL_" + key)
            );
        }
    }
    
    
    // OptionsCategory.Panel ...................................................
    
    void update () {
        model = new CodeTemplatesModel ();

        cbLanguage.removeActionListener (this);
        bNew.removeActionListener (this);
        bRemove.removeActionListener (this);
        cbExpander.removeActionListener (this);
        tTemplates.getSelectionModel ().removeListSelectionListener (this);
        
        cbLanguage.removeAllItems ();
        List languages = new ArrayList (model.getLanguages ());
        Collections.sort (languages);
        Iterator it = languages.iterator ();
        while (it.hasNext ()) cbLanguage.addItem (it.next ());
        KeyStroke expander = model.getExpander ();
        if (KeyStroke.getKeyStroke (KeyEvent.VK_SPACE, KeyEvent.SHIFT_MASK).equals (expander))
            cbExpander.setSelectedIndex (1);
        else
        if (KeyStroke.getKeyStroke (KeyEvent.VK_TAB, 0).equals (expander))
            cbExpander.setSelectedIndex (2);
        else
        if (KeyStroke.getKeyStroke (KeyEvent.VK_ENTER, 0).equals (expander))
            cbExpander.setSelectedIndex (3);
        else
            cbExpander.setSelectedIndex (0);
        
        cbLanguage.addActionListener (this);
        bNew.addActionListener (this);
        bRemove.addActionListener (this);
        cbExpander.addActionListener (this);
        tTemplates.getSelectionModel ().addListSelectionListener (this);
        cbLanguage.setSelectedItem ("Java");
    }
    
    void applyChanges () {
        if (model != null) {
            saveCurrentTemplate ();
            model.saveChanges ();
        }
    }
    
    void cancel () {
    }
    
    boolean dataValid () {
        return true;
    }
    
    boolean isChanged () {
        if (model == null) return false;
        return model.isChanged ();
    }
    
    // ActionListener ..........................................................
    
    public void actionPerformed (ActionEvent e) {
        if (e.getSource () == cbLanguage) {
            saveCurrentTemplate ();
            final String language = (String) cbLanguage.getSelectedItem ();
            final TableModel tableModel = model.getTableModel (language);
            tTemplates.setModel (tableModel);
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    epTemplates.setContentType (model.getMimeType (language));
                    if (tableModel.getRowCount () > 0) {
                        lastIndex = -1;
                        tTemplates.getSelectionModel ().setSelectionInterval (0, 0);
                        lastIndex = 0;
                    } else
                        lastIndex = -1;
                }
            });
        } else
        if (e.getSource () == bNew) {
            saveCurrentTemplate ();
            InputLine descriptor = new InputLine (
                loc ("CTL_Enter_template_name"),
                loc ("CTL_New_template_dialog_title")
            );
            if (DialogDisplayer.getDefault ().notify (descriptor) ==
                InputLine.OK_OPTION
            ) {
                String templateName = descriptor.getInputText ().trim ();
                if (templateName.length () == 0) {
                    DialogDisplayer.getDefault ().notify (
                        new NotifyDescriptor.Message (
                            loc ("CTL_Empty_template_name"),
                            NotifyDescriptor.ERROR_MESSAGE
                        )
                    );
                } else {
                    TableModel tableModel = tTemplates.getModel ();
                    int i, k = tableModel.getRowCount ();
                    for (i = 0; i < k; i++) {
                        String name = (String) tableModel.getValueAt (i, 0);
                        if (templateName.equals (name)) {
                            DialogDisplayer.getDefault ().notify (
                                new NotifyDescriptor.Message (
                                    loc ("CTL_Duplicate_template_name"),
                                    NotifyDescriptor.ERROR_MESSAGE
                                )
                            );
                            break;
                        }
                    }
                    if (i == k) {
                        String language = (String) cbLanguage.getSelectedItem ();
                        lastIndex = -1;
                        model.addRow (language, templateName, "");
                        tTemplates.getSelectionModel ().setSelectionInterval (0, 0);
                        spTable.getVerticalScrollBar ().setValue (0);
                    }
                }
            }
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    epTemplates.requestFocus ();
                }
            });
        } else
        if (e.getSource () == bRemove) {
            String language = (String) cbLanguage.getSelectedItem ();
            int index = tTemplates.getSelectedRow ();
            model.removeRow (language, index);
            lastIndex = -1;
            if (index < tTemplates.getModel ().getRowCount ())
                tTemplates.getSelectionModel ().setSelectionInterval 
                    (index, index);
            else
            if (tTemplates.getModel ().getRowCount () > 0)
                tTemplates.getSelectionModel ().setSelectionInterval (
                    tTemplates.getModel ().getRowCount () - 1,
                    tTemplates.getModel ().getRowCount () - 1
                );
            else
                bRemove.setEnabled (false);
        } else
        if (e.getSource () == cbExpander) {
            switch (cbExpander.getSelectedIndex ()) {
                case 0:model.setExpander (KeyStroke.getKeyStroke (KeyEvent.VK_SPACE, 0));
                    break;
                case 1:model.setExpander (KeyStroke.getKeyStroke (KeyEvent.VK_SPACE, KeyEvent.SHIFT_MASK));
                    break;
                case 2:model.setExpander (KeyStroke.getKeyStroke (KeyEvent.VK_TAB, 0));
                    break;
                case 3:model.setExpander (KeyStroke.getKeyStroke (KeyEvent.VK_ENTER, 0));
                    break;
            }
        }
    }
    
    public void valueChanged (ListSelectionEvent e) {
        // new line in code templates table has been selected
        int index = tTemplates.getSelectedRow ();
        if (index < 0) {
            epTemplates.setText ("");
            bRemove.setEnabled (false);
            lastIndex = -1;
            return;
        }
        saveCurrentTemplate ();
        TableModel tableModel = tTemplates.getModel ();
        bRemove.setEnabled (true);
        String text = (String) tableModel.getValueAt (index, 1);
        epTemplates.setText (text);
        lastIndex = index;
    }
    
    private Lookup lookup;
    
    void setLookup (Lookup lookup) {
        this.lookup = lookup;
    }
    
    private int lastIndex = -1;
    
    void saveCurrentTemplate () {
        TableModel tableModel = tTemplates.getModel ();
        if (lastIndex < 0) return;
        if (epTemplates.getText ().equals (tableModel.getValueAt (lastIndex, 1)))
            return;
        tableModel.setValueAt (
            epTemplates.getText (),
            lastIndex,
            1
        );
        firePropertyChange (OptionsPanelController.PROP_CHANGED, null, null);
    }
}



