/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.codetemplates;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.editor.BaseKit;

import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


class CodeTemplatesModel implements TableModelListener {
    
    private List        languages = new ArrayList ();
    /** Map (String (localized language name) > String (localised language name)). */
    private Map         languagesMap = new HashMap ();
    /** Set (String (localized language name)). */
    private Set         modifiedLanguages = new HashSet ();
    private Map         languageToModel = new HashMap ();
    private Map         languageToMimeType = new HashMap ();
    private Map         modelToLanguage = new HashMap ();
    
    
    CodeTemplatesModel () {
        
        Iterator it = AllOptionsFolder.getDefault ().getInstalledOptions ().
            iterator ();    
        Vector columns = new Vector ();
        columns.add (loc ("Abbreviation_Title"));
        columns.add (loc ("Expanded_Text_Title"));
        while (it.hasNext ()) {
            Class optionsClass = (Class) it.next ();
            BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
                (optionsClass, true);
            String language = baseOptions.getTypeName ();
            
            // localize language name
            try {
                String localizedLanguage = NbBundle.getMessage 
                    (CodeTemplatesModel.class, language);
                languagesMap.put (language, localizedLanguage);
                language = localizedLanguage;
            } catch (MissingResourceException ex) {
                languagesMap.put (language, language);
            }
            languages.add (language);
            
            Map abbreviationsMap = baseOptions.getAbbrevMap ();
            
            Iterator it2 = abbreviationsMap.keySet ().iterator ();
            List table = new ArrayList ();
            while (it2.hasNext ()) {
                String abbreviation = (String) it2.next ();
                Vector line =  new Vector (2);
                line.add (abbreviation);
                line.add (abbreviationsMap.get (abbreviation));
                table.add (line);
            }
            Collections.sort (table, new MComparator ());
            DefaultTableModel tableModel = new DefaultTableModel 
                (new Vector (table), columns) {
                public boolean isCellEditable (int row, int column) {
                    return false;
                }
            };
            tableModel.addTableModelListener (this);
            modelToLanguage.put (tableModel, language);
            languageToModel.put (language, tableModel);
            BaseKit kit = BaseKit.getKit (baseOptions.getKitClass ());
            languageToMimeType.put (language, kit.getContentType ());
        }
        expander = BaseOptions.getCodeTemplateExpandKey ();
    }
    
    List getLanguages () {
        return languages;
    }
    
    String getMimeType (String language) {
        return (String) languageToMimeType.get (language);
    }
    
    DefaultTableModel getTableModel (String language) {
        return (DefaultTableModel) languageToModel.get (language);
    }
    
    void addRow (String language, String abbreviation, String text) {
        DefaultTableModel tableModel = getTableModel (language);
        Vector newLine = new Vector ();
        newLine.add (abbreviation);
        newLine.add (text);
        tableModel.insertRow (0, newLine);
        modifiedLanguages.add (language);
    }
    
    void removeRow (String language, int index) {
        DefaultTableModel tableModel = getTableModel (language);
        tableModel.removeRow (index);
        modifiedLanguages.add (language);
    }
    
    void saveChanges () {
        Iterator it = AllOptionsFolder.getDefault ().getInstalledOptions ().
            iterator ();
        while (it.hasNext ()) {
            Class optionsClass = (Class) it.next ();
            BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
                (optionsClass, true);
            String language = baseOptions.getTypeName ();
            language = (String) languagesMap.get (language);
            if (!modifiedLanguages.contains (language))
                continue;
            
            DefaultTableModel tableModel = getTableModel (language);
            Map abbreviationsMap = new HashMap ();
            int i, k = tableModel.getRowCount ();
            for (i = 0; i < k; i++) {
                abbreviationsMap.put (
                    tableModel.getValueAt (i, 0),
                    tableModel.getValueAt (i, 1)
                );
            }
            baseOptions.setAbbrevMap (abbreviationsMap);
        }
        if (expander != null && 
            !BaseOptions.getCodeTemplateExpandKey ().equals (expander)
        )
            BaseOptions.setCodeTemplateExpandKey (expander);
    }
    
    boolean isChanged () {
        return !modifiedLanguages.isEmpty () ||
            !BaseOptions.getCodeTemplateExpandKey ().equals (expander);
    }
    
    public void tableChanged (TableModelEvent e) {
        DefaultTableModel tableModel = (DefaultTableModel) e.getSource ();
        String language = (String) modelToLanguage.get (tableModel);
        modifiedLanguages.add (language);
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (CodeTemplatesModel.class, key);
    }
    
    KeyStroke getExpander () {
        return expander;
    }
    
    private KeyStroke expander;
    void setExpander (KeyStroke expander) {
        this.expander = expander;
    }
    
    private static class MComparator implements Comparator {
        public int compare (Object o1, Object o2) {
            String s1 = (String) ((Vector) o1).get (0);
            String s2 = (String) ((Vector) o2).get (0);
            return s1.compareTo (s2);
        }
    }    
}


