/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.editor.mimelookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObject.Container;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.Lookup.Result;
import org.openide.util.Lookup.Template;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ProxyLookup;

/** FolderLookup that will merge objects from all inherited layer folders
 *
 *  @author Martin Roskanin
 */
public class CompositeLayerFolderLookup extends Lookup {
    
    private Map class2CompositeResults = new HashMap(); //<CompositeResult>
    private List inheritedFolders;
    private InstanceProvider instanceProvider;
    private List listeners = new ArrayList();
    
    public CompositeLayerFolderLookup (InstanceProvider instanceProvider, List inheritedFolders) {
        this.instanceProvider = instanceProvider;
        this.inheritedFolders = inheritedFolders;
        if (inheritedFolders!=null){
            for (int i = 0; i<inheritedFolders.size(); i++){
                DataFolder df = (DataFolder)inheritedFolders.get(i);
                MyFolderListener listener = new MyFolderListener();
                listeners.add(listener);
                df.getPrimaryFile().addFileChangeListener(
                    FileUtil.weakFileChangeListener(
                    listener, df.getPrimaryFile())
                    );
            }
        }
    }

    public Result lookup(Template template) {
        Class templateClass = template.getType();
        CompositeResult result = null;
        synchronized (class2CompositeResults) {
            result = (CompositeResult)class2CompositeResults.get(templateClass);
            if (result == null){
                result = new CompositeResult(templateClass);
            }
            class2CompositeResults.put(templateClass, result);
        }
        return result;
    }

    public Object lookup(Class clazz) {
        return null;
    }
    
    
    private class CompositeResult extends Lookup.Result{
        
        private final Set listeners = new HashSet(10); // Set<LookupListener>
        private Class clazz;
        private List foPaths = new ArrayList();
        
        public CompositeResult(Class clazz){
            this.clazz = clazz;
            List ordered = MimeLookupUtils.mergeObjects(inheritedFolders);
            List retList = new ArrayList();
            for (int i = 0; i<inheritedFolders.size(); i++){
                DataFolder folder = (DataFolder)inheritedFolders.get(i);
                DataObject dobjs[] = folder.getChildren();
                if (dobjs!=null){
                    for (int j = 0; j<dobjs.length; j++){
                        DataObject dob  = dobjs[j];
                        if (instanceProvider!=null || isAssignable(dob)){
                            foPaths.add(dob.getPrimaryFile().getPath());
                        }
                    }
                }
            }
        }

        public void addLookupListener(LookupListener l) {
            synchronized (listeners) {
                listeners.add(l);
            }
        }
        public void removeLookupListener(LookupListener l) {
            synchronized (listeners) {
                listeners.remove(l);
            }
        }
        
        public void changed(FileObject fobj) {
            LookupListener[] ll;
            synchronized (listeners) {
                if (listeners.isEmpty()) {
                    return;
                }
                ll = (LookupListener[])listeners.toArray(new LookupListener[listeners.size()]);
            }

            boolean fire = false;
            
            DataObject dobj = null;
            try{
                dobj = DataObject.find(fobj);
            } catch (DataObjectNotFoundException donfe){
            }
            if (fobj.isValid() & dobj!=null){
                //new added file
                if (instanceProvider != null || isAssignable(dobj)){
                    fire = true;
                    String path = fobj.getPath();
                    if (!foPaths.contains(path)){
                        foPaths.add(path);
                    }
                }
            } else {
                // deleted
                String path = fobj.getPath();
                if (foPaths.contains(path)){
                    foPaths.remove(path);
                    fire = true;
                }
            }
            
            if (fire){
                LookupEvent ev = new LookupEvent(this);
                for (int i = 0; i < ll.length; i++) {
                    ll[i].resultChanged(ev);
                }
            }
        }

        private boolean isAssignable(DataObject dob){
            InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
            if (ic!=null){
                try{
                    if (clazz.isAssignableFrom(ic.instanceClass())){
                        return true;
                    }
                }catch(IOException ioe){
                    ioe.printStackTrace();
                }catch(ClassNotFoundException cnfe){
                    cnfe.printStackTrace();
                }
            }
            return false;
        }
        
        public java.util.Collection allInstances() {
            List ordered = MimeLookupUtils.mergeObjects(inheritedFolders);
            List retList = new ArrayList();
            if (instanceProvider != null){
                retList.add(instanceProvider.createInstance(ordered));
                return retList;
            }
            for (int i = 0; i<ordered.size(); i++){
                DataObject dob = (DataObject) ordered.get(i);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic!=null){
                    try{
                        if (clazz.isAssignableFrom(ic.instanceClass())){
                            retList.add(ic.instanceCreate());
                        }
                    }catch(IOException ioe){
                        ioe.printStackTrace();
                    }catch(ClassNotFoundException cnfe){
                        cnfe.printStackTrace();
                    }
                }
            }
            return retList;
        }
        
    }
    
    private class MyFolderListener extends FileChangeAdapter{
        
        public MyFolderListener(){
        }
        
        private void fire(FileObject fobj){
            synchronized (class2CompositeResults){
                Collection c = class2CompositeResults.values();
                Iterator it = c.iterator();
                while(it.hasNext()){
                    CompositeResult res = (CompositeResult) it.next();
                    res.changed(fobj);
                }
            }
        }
        
        public void fileDeleted(FileEvent fe) {
            fire(fe.getFile());
        }
        
        public void fileDataCreated(FileEvent fe) {
            fire(fe.getFile());
        }        
        
        public void fileFolderCreated(FileEvent fe){
            fire(fe.getFile());
        }
    }    
    
}
