/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.editor.view;

import javax.swing.text.AbstractDocument;
import javax.swing.text.View;
import org.netbeans.editor.view.spi.FlyView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewLayoutState;

/**
 * Extension of {@link SimpleViewLayoutState}
 * that thoroughly handles minimum and maximum spans.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public class DefaultViewLayoutState extends SimpleViewLayoutState {
    
    private float layoutMinorAxisMinimumSpan;

    private float layoutMinorAxisMaximumSpan;


    public DefaultViewLayoutState(View v) {
        super(v);
    }

    protected boolean minorAxisUpdateLayout(int minorAxis) {
        View view = getView();
        boolean minorAxisPreferenceChanged = false;
        float val;
        
        val = view.getMaximumSpan(minorAxis);
        if (val != getLayoutMinorAxisMaximumSpan()) {
            setLayoutMinorAxisMaximumSpan(val);
            minorAxisPreferenceChanged = true;
        }
        
        val = view.getMinimumSpan(minorAxis);
        if (val != getLayoutMinorAxisMinimumSpan()) {
            setLayoutMinorAxisMinimumSpan(val);
            minorAxisPreferenceChanged = true;
        }
        
        return minorAxisPreferenceChanged;
    }
    
    public float getLayoutMinorAxisMaximumSpan() {
        return layoutMinorAxisMaximumSpan;
    }
    
    public void setLayoutMinorAxisMaximumSpan(float layoutMinorAxisMaximumSpan) {
        this.layoutMinorAxisMaximumSpan = layoutMinorAxisMaximumSpan;
    }

    public float getLayoutMinorAxisMinimumSpan() {
        return layoutMinorAxisMinimumSpan;
    }
    
    public void setLayoutMinorAxisMinimumSpan(float layoutMinorAxisMinimumSpan) {
        this.layoutMinorAxisMinimumSpan = layoutMinorAxisMinimumSpan;
    }

}
