/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;

/**
 * Default implementation of the provider manager.
 * <br>
 * The default empty list of hyperlink providers
 * can be extended by registering new ones for each mimetype.
 *
 * @author Miloslav Metelka
 */
public class DefaultHyperlinkProviderManager extends HyperlinkProviderManager {
    
    private Map mimeType2providerList = new HashMap();
    
    /**
     * Register a new HyperlinkProvider.
     *
     * @param mimeType mime-type for which the provider is being registered.
     * @param provider provider to register.
     */
    public synchronized void addHyperlinkProvider(String mimeType, HyperlinkProvider provider) {
        getProviderList(mimeType, true).add(provider);
    }
    
    /**
     * Unregister a HyperlinkProvider.
     *
     * @param mimeType mime-type for which the provider is being unregistered.
     * @param provider provider to unregister.
     */
    public synchronized void removeHyperlinkProvider(String mimeType, HyperlinkProvider provider) {
        List providerList = getProviderList(mimeType, false);
        if (providerList != null) {
            providerList.remove(provider);
        }
    }
    
    public synchronized List/*<HyperlinkProvider>*/ getHyperlinkProviders(String mimeType) {
        List providers = getProviderList(mimeType, false);
        return (providers != null) ? providers : Collections.EMPTY_LIST;
    }
    
    private List getProviderList(String mimeType, boolean forceCreation) {
        List providerList = (List)mimeType2providerList.get(mimeType);
        if (providerList == null && forceCreation) {
            providerList = new ArrayList();
            mimeType2providerList.put(mimeType, providerList);
        }
        return providerList;
    }
    
}
