/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.view.spi;

/**
 * Views that implement this interface
 * signal that they work in a mode when
 * they just estimate their size instead
 * of exact measurements that are likely
 * more expensive for computation.
 * <br>
 * By default the view should be in non-estimated mode
 * i.e. the exact measurements should be used
 * unless the estimated span flag is set.
 *
 * <p>
 * If a particular view does not implement this interface
 * then it is assumed that the view uses exact measurements.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public interface EstimatedSpanView {
    
    /**
     * Check whether this view is currently
     * in a mode when it just estimates its span.
     *
     * @return true if the view estimates its preferred horizontal
     *   and vertical preferred, maximum and minimum spans.
     *   Returns false if the view measurements are exact.
     */
    public boolean isEstimatedSpan();
    
    /**
     * Set whether this view uses estimated span computation
     * instead of exact measurements.
     *
     * @param estimatedSpan whether view will estimate
     *  the spans or use exact measurements.
     */
    public void setEstimatedSpan(boolean estimatedSpan);
    
}
