/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext;

import javax.swing.text.Position;
import org.netbeans.editor.TokenItem;

/**
* Position consisting of the token-item
* and the offset inside it. The offset can range from zero to the
* last character in the token-text. The position right after
* the last character in the last token is expressed by token
* equal to null and offset equal to zero.
* The equality is defined as having the same offset in the same token.
* The token is compared just by equality operator.
*
* @author Miloslav Metelka
* @version 1.00
*/

public interface FormatTokenPosition {

    /** Get the token-item in which the position resides. */
    public TokenItem getToken();

    /** Get the offset inside the token-item. */
    public int getOffset();

    /** Get the bias of the position. Either Position.Bias.Forward
     * or Position.Bias.Backward.
     */
    public Position.Bias getBias();

}
