/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext;

/**
* Formatting layer that can be added to <tt>BaseFormatter</tt>
* to format the tokens.
*
* @author Miloslav Metelka
* @version 1.00
*/

public interface FormatLayer {

    /** Get the name of the layer. This name is used to identify
    * the layer when it's being removed or replaced and it can
    * be used for debugging purposes too.
    */
    public String getName();

    /** Format the tokens begining with the firstItem till the end.
    * @param fw format-writer to be formatted. The format-layer
    *  will usually create the format-support as an abstraction
    *  level over the format-layer.
    */
    public void format(FormatWriter fw);

}
