/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext;

import org.netbeans.editor.BaseTextUI;
import javax.swing.text.JTextComponent;
import javax.swing.plaf.TextUI;

/**
* Extended kit offering advanced functionality
*
* @author Miloslav Metelka
* @version 1.00
*/
public class ExtUtilities {
    

    
    private ExtUtilities() {
    }

    public static ExtEditorUI getExtEditorUI(JTextComponent target) {
        TextUI ui = target.getUI();
        return (ui instanceof BaseTextUI)
            ? (ExtEditorUI)((BaseTextUI)ui).getEditorUI()
            : null;
    }

    public static Completion getCompletion(JTextComponent target) {
        ExtEditorUI extEditorUI = getExtEditorUI(target);
        if (extEditorUI != null) {
            return extEditorUI.getCompletion();
        }
        return null;
    }

    public static CompletionJavaDoc getCompletionJavaDoc(JTextComponent target) {
        ExtEditorUI extEditorUI = getExtEditorUI(target);
        if (extEditorUI != null) {
            return extEditorUI.getCompletionJavaDoc();
        }
        return null;
    }
    
    public static JDCPopupPanel getJDCPopupPanel(JTextComponent target) {
        ExtEditorUI extEditorUI = getExtEditorUI(target);
        if (extEditorUI != null) {
            Completion c = extEditorUI.getCompletion();
            if (c!=null) {
                return c.getJDCPopupPanel();
            }
        }
        return null;
    }
    

}
