/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext;

/**
* Pane displaying the completion view and accompanying components
* like label for title etc. It can be a scroll-pane with the label
* at the top or something else.
*
* @author Miloslav Metelka
* @version 1.00
*/

public interface CompletionPane {

    /** Is the pane visible? */
    public boolean isVisible();

    /** Set the pane to be visible. */
    public void setVisible(boolean visible);

    /** Possibly refresh the look after either the view was changed
    * or title was changed or both.
    */
    public void refresh();

    /** Set the title of the pane according to the completion query results. */
    public void setTitle(String title);

}
